/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reflections8.Configuration;
import org.reflections8.ReflectionUtils;
import org.reflections8.ReflectionsException;
import org.reflections8.Store;
import org.reflections8.scanners.FieldAnnotationsScanner;
import org.reflections8.scanners.MemberUsageScanner;
import org.reflections8.scanners.MethodAnnotationsScanner;
import org.reflections8.scanners.MethodParameterNamesScanner;
import org.reflections8.scanners.MethodParameterScanner;
import org.reflections8.scanners.ResourcesScanner;
import org.reflections8.scanners.Scanner;
import org.reflections8.scanners.SubTypesScanner;
import org.reflections8.scanners.TypeAnnotationsScanner;
import org.reflections8.serializers.Serializer;
import org.reflections8.serializers.XmlSerializer;
import org.reflections8.util.ClasspathHelper;
import org.reflections8.util.ConfigurationBuilder;
import org.reflections8.util.FilterBuilder;
import org.reflections8.util.HashSetMultimap;
import org.reflections8.util.Joiner;
import org.reflections8.util.ReflectionsIterables;
import org.reflections8.util.SetMultimap;
import org.reflections8.util.Utils;
import org.reflections8.vfs.Vfs;
import org.slf4j.Logger;

public class Reflections {
    public static final Optional<Logger> log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(Utils.index(scanner.getClass())));
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    public Reflections(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(this.configuration);
    }

    /*
     * WARNING - void declaration
     */
    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log.isPresent()) {
                log.get().warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log.isPresent() && log.get().isDebugEnabled()) {
            log.get().debug("going to scan these urls:\n{}", (Object)Joiner.on("\n").join(this.configuration.getUrls()));
        }
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        Optional<ExecutorService> executorService = this.configuration.getExecutorService();
        ArrayList futures = new ArrayList();
        for (final URL uRL : this.configuration.getUrls()) {
            try {
                if (executorService.isPresent()) {
                    futures.add(executorService.get().submit(new Runnable(){

                        @Override
                        public void run() {
                            if (log.isPresent()) {
                                log.get().debug("[{}] scanning {}", (Object)Thread.currentThread().toString(), (Object)uRL);
                            }
                            Reflections.this.scan(uRL);
                        }
                    }));
                } else {
                    this.scan(uRL);
                }
                ++scannedUrls;
            }
            catch (ReflectionsException e) {
                if (!log.isPresent()) continue;
                log.get().warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
            }
        }
        if (executorService.isPresent()) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        if (executorService.isPresent()) {
            executorService.get().shutdown();
        }
        if (log.isPresent()) {
            void var7_11;
            int keys2 = 0;
            boolean bl = false;
            for (String index : this.store.keySet()) {
                keys2 += this.store.get(index).keySet().size();
                for (Collection c : this.store.get(index).values()) {
                    var7_11 += c.size();
                }
            }
            log.get().trace(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, scannedUrls, keys2, (int)var7_11, executorService.isPresent() && executorService.get() instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService.get()).getMaximumPoolSize()) : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL url) {
        try (Vfs.Dir dir = Vfs.fromURL(url);){
            for (Vfs.File file : dir.getFiles()) {
                Optional<Predicate<String>> inputsFilter = this.configuration.getInputsFilter();
                String path = file.getRelativePath();
                String fqn = path.replace('/', '.');
                if (inputsFilter.isPresent() && !inputsFilter.get().test(path) && !inputsFilter.get().test(fqn)) continue;
                Optional<Object> classObject = Optional.empty();
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(path) && !scanner.acceptsInput(fqn)) continue;
                        classObject = Optional.of(scanner.scan(file, classObject));
                    }
                    catch (Exception e) {
                        if (!log.isPresent()) continue;
                        log.get().debug("could not scan file {} in url {} with scanner {}", new Object[]{file.getRelativePath(), url.toExternalForm(), scanner.getClass().getSimpleName(), e});
                    }
                }
            }
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections/", new FilterBuilder().include(".*-reflections.xml"), new Serializer[0]);
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer ... optionalSerializer) {
        XmlSerializer serializer = optionalSerializer != null && optionalSerializer.length == 1 ? optionalSerializer[0] : new XmlSerializer();
        Collection<URL> urls = ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]);
        if (urls.isEmpty()) {
            return null;
        }
        long start2 = System.currentTimeMillis();
        Reflections reflections8 = new Reflections();
        Iterable<Vfs.File> files = Vfs.findFiles(urls, packagePrefix, resourceNameFilter);
        for (Vfs.File file : files) {
            try {
                InputStream inputStream = file.openInputStream();
                Object object = null;
                try {
                    reflections8.merge(serializer.read(inputStream));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream == null) continue;
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
        }
        if (log.isPresent()) {
            Store store = reflections8.getStore();
            int keys2 = 0;
            int values2 = 0;
            for (String index : store.keySet()) {
                keys2 += store.get(index).keySet().size();
                values2 += store.get(index).size();
            }
            log.get().info(String.format("Reflections took %d ms to collect %d url%s, producing %d keys and %d values [%s]", System.currentTimeMillis() - start2, urls.size(), urls.size() > 1 ? "s" : "", keys2, values2, Joiner.on(", ").join(urls)));
        }
        return reflections8;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            if (log.isPresent()) {
                log.get().info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        Reflections reflections;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            reflections = this.collect(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ReflectionsException("could not obtain input stream from file " + file, e);
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
        }
        Utils.close(inputStream);
        return reflections;
    }

    public Reflections merge(Reflections reflections8) {
        if (reflections8.store != null) {
            for (String indexName : reflections8.store.keySet()) {
                SetMultimap<String, String> index = reflections8.store.get(indexName);
                for (String key : index.keySet()) {
                    for (String string : (Set)index.get(key)) {
                        this.store.getOrCreate(indexName).putSingle(key, string);
                    }
                }
            }
        }
        return this;
    }

    public void expandSuperTypes() {
        if (this.store.keySet().contains(Utils.index(SubTypesScanner.class))) {
            SetMultimap<String, String> mmap = this.store.get(Utils.index(SubTypesScanner.class));
            HashSet difference = new HashSet();
            difference.addAll(mmap.keySet());
            difference.removeAll(mmap.flatValuesAsSet());
            HashSetMultimap<String, String> expand = new HashSetMultimap<String, String>();
            for (String key : difference) {
                Class<?> type2 = ReflectionUtils.forName(key, this.loaders());
                if (type2 == null) continue;
                this.expandSupertypes(expand, key, type2);
            }
            mmap.putAllSingles(expand);
        }
    }

    private void expandSupertypes(SetMultimap<String, String> mmap, String key, Class<?> type2) {
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type2)) {
            if (!mmap.putSingle(supertype.getName(), key)) continue;
            if (log.isPresent()) {
                log.get().debug("expanded subtype {} -> {}", (Object)supertype.getName(), (Object)key);
            }
            this.expandSupertypes(mmap, supertype.getName(), supertype);
        }
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type2) {
        return new HashSet<Class<? extends T>>(ReflectionUtils.forNames(this.store.getAll(Utils.index(SubTypesScanner.class), Arrays.asList(type2.getName())), this.loaders()));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Iterable<String> annotated = this.store.get(Utils.index(TypeAnnotationsScanner.class), annotation.getName());
        Iterable<String> classes = this.getAllAnnotated(annotated, annotation.isAnnotationPresent(Inherited.class), honorInherited);
        return Stream.concat(ReflectionUtils.forNames(annotated, this.loaders()).stream(), ReflectionUtils.forNames(classes, this.loaders()).stream()).collect(Collectors.toSet());
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        Iterable<String> annotated = this.store.get(Utils.index(TypeAnnotationsScanner.class), annotation.annotationType().getName());
        Set<Class<?>> filter = ReflectionUtils.filter(ReflectionUtils.forNames(annotated, this.loaders()), ReflectionUtils.withAnnotation(annotation));
        Iterable<String> classes = this.getAllAnnotated(Utils.names(filter), annotation.annotationType().isAnnotationPresent(Inherited.class), honorInherited);
        Stream<String> classesStream = StreamSupport.stream(classes.spliterator(), false);
        Stream filterStream = StreamSupport.stream(filter.spliterator(), false);
        final HashSet<String> annotatedSet = new HashSet<String>();
        for (String clazz : annotated) {
            annotatedSet.add(clazz);
        }
        return Stream.concat(filterStream, ReflectionUtils.forNames((Iterable<String>)classesStream.filter(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return !annotatedSet.contains(s);
            }
        }).collect(Collectors.toList()), this.loaders()).stream()).collect(Collectors.toSet());
    }

    protected Iterable<String> getAllAnnotated(Iterable<String> annotated, boolean inherited, boolean honorInherited) {
        if (honorInherited) {
            if (inherited) {
                Iterable<String> subTypes = this.store.get(Utils.index(SubTypesScanner.class), ReflectionUtils.filter(annotated, new Predicate<String>(){

                    @Override
                    public boolean test(String input) {
                        Class<?> type2 = ReflectionUtils.forName(input, Reflections.this.loaders());
                        return type2 != null && !type2.isInterface();
                    }
                }));
                return ReflectionsIterables.concat(subTypes, this.store.getAll(Utils.index(SubTypesScanner.class), subTypes));
            }
            return annotated;
        }
        Iterable<String> subTypes = ReflectionsIterables.concat(annotated, this.store.getAll(Utils.index(TypeAnnotationsScanner.class), annotated));
        return ReflectionsIterables.concat(subTypes, this.store.getAll(Utils.index(SubTypesScanner.class), subTypes));
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Iterable<String> methods = this.store.get(Utils.index(MethodAnnotationsScanner.class), annotation.getName());
        return Utils.getMethodsFromDescriptors(methods, this.loaders());
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.filter(this.getMethodsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Method> getMethodsMatchParams(Class<?> ... types) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(types).toString()), this.loaders());
    }

    public Set<Method> getMethodsReturn(Class returnType) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(returnType)), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), annotation.getName()), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.filter(this.getMethodsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> annotation) {
        Iterable<String> methods = this.store.get(Utils.index(MethodAnnotationsScanner.class), annotation.getName());
        return Utils.getConstructorsFromDescriptors(methods, this.loaders());
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.filter(this.getConstructorsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsMatchParams(Class<?> ... types) {
        return Utils.getConstructorsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(types).toString()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getConstructorsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), annotation.getName()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.filter(this.getConstructorsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        HashSet<Field> result = new HashSet<Field>();
        for (String annotated : this.store.get(Utils.index(FieldAnnotationsScanner.class), annotation.getName())) {
            result.add(Utils.getFieldFromString(annotated, this.loaders()));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return ReflectionUtils.filter(this.getFieldsAnnotatedWith(annotation.annotationType()), ReflectionUtils.withAnnotation(annotation));
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        HashSet<String> result = new HashSet<String>();
        Stream<String> resources = this.store.get(Utils.index(ResourcesScanner.class)).keySet().stream().filter(namePredicate);
        this.store.get(Utils.index(ResourcesScanner.class), resources.collect(Collectors.toSet())).forEach(s -> result.add((String)s));
        return result;
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            @Override
            public boolean test(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public List<String> getMethodParamNames(Method method) {
        Iterable<String> names = this.store.get(Utils.index(MethodParameterNamesScanner.class), Utils.name(method));
        return names != null && names.iterator().hasNext() ? Arrays.asList(ReflectionsIterables.getOnlyElement(names).split(", ")) : Arrays.asList(new String[0]);
    }

    public List<String> getConstructorParamNames(Constructor constructor) {
        Iterable<String> names = this.store.get(Utils.index(MethodParameterNamesScanner.class), Utils.name(constructor));
        return !ReflectionsIterables.isEmpty(names) ? Arrays.asList(ReflectionsIterables.getOnlyElement(names).split(", ")) : Arrays.asList(new String[0]);
    }

    public Set<Member> getFieldUsage(Field field) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(field)), new ClassLoader[0]);
    }

    public Set<Member> getMethodUsage(Method method) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(method)), new ClassLoader[0]);
    }

    public Set<Member> getConstructorUsage(Constructor constructor) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(constructor)), new ClassLoader[0]);
    }

    public Set<String> getAllTypes() {
        Set<String> allTypes = ReflectionsIterables.makeSetOf(this.store.getAll(Utils.index(SubTypesScanner.class), Object.class.getName()));
        if (allTypes.isEmpty()) {
            throw new ReflectionsException("Couldn't find subtypes of Object. Make sure SubTypesScanner initialized to include Object class - new SubTypesScanner(false)");
        }
        return allTypes;
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        if (log.isPresent()) {
            log.get().info("Reflections successfully saved in " + file.getAbsolutePath() + " using " + serializer.getClass().getSimpleName());
        }
        return file;
    }

    private Optional<ClassLoader[]> loaders() {
        return this.configuration.getClassLoaders();
    }
}

