/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.Consts;
import io.jpower.kcp.netty.DefaultUkcpClientChannelConfig;
import io.jpower.kcp.netty.Kcp;
import io.jpower.kcp.netty.KcpException;
import io.jpower.kcp.netty.KcpOutput;
import io.jpower.kcp.netty.Ukcp;
import io.jpower.kcp.netty.UkcpChannel;
import io.jpower.kcp.netty.UkcpClientChannelConfig;
import io.jpower.kcp.netty.UkcpClientUdpChannel;
import io.jpower.kcp.netty.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.nio.NioEventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class UkcpClientChannel
extends AbstractChannel
implements UkcpChannel,
Runnable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(UkcpClientChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final DefaultUkcpClientChannelConfig config;
    private final UkcpClientUdpChannel udpChannel;
    private final Ukcp ukcp;
    private final KcpOutput output = new UkcpClientOutput();
    private int tsUpdate;
    private boolean scheduleUpdate;
    private boolean flushPending;
    boolean closeAnother = false;

    public UkcpClientChannel() {
        super(null);
        this.udpChannel = new UkcpClientUdpChannel(this);
        this.ukcp = this.createUkcp();
        this.config = new DefaultUkcpClientChannelConfig(this, this.ukcp, this.udpChannel.javaChannel().socket());
    }

    private Ukcp createUkcp() {
        Ukcp ukcp = new Ukcp(0L, this.output);
        ukcp.channel(this);
        return ukcp;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public UkcpClientChannelConfig config() {
        return this.config;
    }

    public UkcpClientUnsafe unsafe() {
        return (UkcpClientUnsafe)super.unsafe();
    }

    protected UkcpClientUnsafe newUnsafe() {
        return new UkcpClientUnsafe();
    }

    public boolean isOpen() {
        return this.udpChannel.isOpen();
    }

    public boolean isActive() {
        return this.udpChannel.isActive();
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof NioEventLoop;
    }

    protected SocketAddress localAddress0() {
        return this.udpChannel.localAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.udpChannel.remoteAddress();
    }

    protected void doRegister() throws Exception {
        this.eventLoop().register((Channel)this.udpChannel).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    UkcpClientChannel.this.forceClose(future.cause());
                }
            }
        });
    }

    private void forceClose(Throwable t) {
        this.unsafe().closeForcibly();
        ((ChannelPromise)this.closeFuture()).trySuccess();
        log.warn("Failed to register an UkcpClientUdpChannel: {}", (Object)this, (Object)t);
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.udpChannel.doBind(localAddress);
    }

    private boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        return this.udpChannel.doConnect(remoteAddress, localAddress);
    }

    protected void doDisconnect() throws Exception {
        this.udpChannel.doDisconnect();
    }

    protected void doClose() throws Exception {
        this.ukcp.setClosed(true);
        if (!this.closeAnother) {
            this.closeAnother = true;
            this.udpChannel.unsafe().close(this.udpChannel.unsafe().voidPromise());
        }
    }

    protected void doBeginRead() throws Exception {
        this.udpChannel.doBeginRead();
    }

    /*
     * Exception decompiling
     */
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public boolean isFlushPending() {
        return this.flushPending;
    }

    @Override
    public long conv() {
        return this.ukcp.getConv();
    }

    @Override
    public UkcpClientChannel conv(int conv) {
        this.ukcp.setConv(conv);
        return this;
    }

    public boolean kcpIsActive() {
        return this.ukcp.isActive();
    }

    void kcpReceive(ByteBuf buf) throws IOException {
        this.ukcp.receive(buf);
    }

    void kcpReceive(List<ByteBuf> bufList) {
        this.ukcp.receive(bufList);
    }

    void kcpInput(ByteBuf buf) throws IOException {
        this.ukcp.input(buf);
    }

    boolean kcpSend(ByteBuf buf) throws IOException {
        if (this.ukcp.canSend(true)) {
            this.ukcp.send(buf);
            return true;
        }
        return false;
    }

    boolean kcpCanRecv() {
        return this.ukcp.canRecv();
    }

    boolean kcpCanSend() {
        return this.ukcp.canSend(!this.flushPending);
    }

    int kcpPeekSize() {
        return this.ukcp.peekSize();
    }

    int kcpUpdate(int current) {
        return this.ukcp.update(current);
    }

    int kcpCheck(int current) {
        return this.ukcp.check(current);
    }

    int kcpTsUpdate() {
        return this.ukcp.getTsUpdate();
    }

    void kcpTsUpdate(int tsUpdate) {
        this.ukcp.setTsUpdate(tsUpdate);
    }

    int kcpState() {
        return this.ukcp.getState();
    }

    void scheduleUpdate(int tsUpdate, int current) {
        if (Consts.sheduleUpdateLog.isDebugEnabled()) {
            Consts.sheduleUpdateLog.debug("schedule delay: " + (tsUpdate - current));
        }
        this.tsUpdate = tsUpdate;
        this.scheduleUpdate = true;
        this.eventLoop().schedule((Runnable)this, (long)(tsUpdate - current), TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (!this.isActive()) {
            return;
        }
        int current = Utils.milliSeconds();
        int nextTsUpdate = 0;
        boolean nextSchedule = false;
        int tsUp = this.kcpTsUpdate();
        Throwable exception = null;
        if (Utils.itimediff(current, tsUp) >= 0) {
            try {
                nextTsUpdate = this.kcpUpdate(current);
                nextSchedule = true;
            }
            catch (Throwable t) {
                exception = t;
            }
            if (this.kcpState() == -1 && exception == null) {
                if (log.isDebugEnabled()) {
                    log.debug("getState=-1 after update(). channel={}", (Object)this);
                }
                exception = new KcpException("State=-1 after update()");
            }
        } else {
            nextTsUpdate = tsUp;
            nextSchedule = true;
        }
        boolean close = false;
        if (exception != null) {
            close = true;
            nextTsUpdate = 0;
            nextSchedule = false;
        } else if (this.isFlushPending() && this.kcpCanSend()) {
            this.unsafe().forceFlush();
        }
        this.tsUpdate = nextTsUpdate;
        this.scheduleUpdate = nextSchedule;
        if (nextSchedule) {
            this.scheduleUpdate(this.tsUpdate, current);
        }
        if (close) {
            Utils.fireExceptionAndClose(this, exception, true);
        }
    }

    private void updateKcp() {
        int current = Utils.milliSeconds();
        Throwable exception = null;
        try {
            this.kcpUpdate(current);
        }
        catch (Throwable t) {
            exception = t;
        }
        if (this.kcpState() == -1 && exception == null) {
            if (log.isDebugEnabled()) {
                log.debug("getState=-1 after update(). channel={}", (Object)this);
            }
            exception = new KcpException("State=-1 after update()");
        }
        if (exception != null) {
            Utils.fireExceptionAndClose(this, exception, true);
        }
    }

    private static class UkcpClientOutput
    implements KcpOutput {
        private UkcpClientOutput() {
        }

        @Override
        public void out(ByteBuf data, Kcp kcp) {
            UkcpClientChannel ukcpChannel = (UkcpClientChannel)kcp.getUser();
            UkcpClientUdpChannel udpChannel = ukcpChannel.udpChannel;
            udpChannel.unsafe().write((Object)data, udpChannel.voidPromise());
            udpChannel.unsafe().flush();
        }
    }

    final class UkcpClientUnsafe
    extends AbstractChannel.AbstractUnsafe {
        UkcpClientUnsafe() {
            super((AbstractChannel)UkcpClientChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                boolean wasActive = UkcpClientChannel.this.isActive();
                if (!UkcpClientChannel.this.doConnect(remoteAddress, localAddress)) {
                    throw new Error();
                }
                this.fulfillConnectPromise(promise, wasActive);
            }
            catch (Throwable t) {
                promise.tryFailure(this.annotateConnectException(t, remoteAddress));
                this.closeIfClosed();
            }
        }

        private void fulfillConnectPromise(ChannelPromise promise, boolean wasActive) {
            if (promise == null) {
                return;
            }
            boolean active = UkcpClientChannel.this.isActive();
            boolean promiseSet = promise.trySuccess();
            if (!wasActive && active) {
                UkcpClientChannel.this.pipeline().fireChannelActive();
            }
            if (!promiseSet) {
                this.close(this.voidPromise());
            }
        }

        protected void flush0() {
            if (UkcpClientChannel.this.isFlushPending()) {
                return;
            }
            super.flush0();
        }

        void forceFlush() {
            super.flush0();
        }
    }
}

