/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.UkcpClientChannel;
import io.jpower.kcp.netty.Utils;
import io.jpower.kcp.netty.internal.CodecOutputList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;

final class UkcpClientUdpChannel
extends AbstractNioMessageChannel {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(UkcpClientUdpChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final UkcpClientChannel ukcpChannel;
    boolean inputShutdown;

    private static DatagramChannel newSocket(SelectorProvider provider) {
        try {
            return provider.openDatagramChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", (Throwable)e);
        }
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel) {
        this(ukcpChannel, UkcpClientUdpChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel, SelectorProvider provider) {
        this(ukcpChannel, UkcpClientUdpChannel.newSocket(provider));
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel, DatagramChannel socket) {
        super(null, (SelectableChannel)socket, 1);
        this.ukcpChannel = ukcpChannel;
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public ChannelConfig config() {
        return this.ukcpChannel.config();
    }

    protected UkcpClientUdpUnsafe newUnsafe() {
        return new UkcpClientUdpUnsafe();
    }

    public boolean isActive() {
        DatagramChannel ch = this.javaChannel();
        return ch.isOpen() && ch.socket().isBound();
    }

    protected DatagramChannel javaChannel() {
        return (DatagramChannel)super.javaChannel();
    }

    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.doBind0(localAddress);
    }

    private void doBind0(SocketAddress localAddress) throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((DatagramChannel)this.javaChannel(), (SocketAddress)localAddress);
        } else {
            this.javaChannel().socket().bind(localAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            this.javaChannel().connect(remoteAddress);
            success = true;
            int current = Utils.milliSeconds();
            int tsUp = this.ukcpChannel.kcpCheck(current);
            this.ukcpChannel.kcpTsUpdate(tsUp);
            this.ukcpChannel.scheduleUpdate(tsUp, current);
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    protected void doFinishConnect() throws Exception {
        throw new Error();
    }

    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    protected void doClose() throws Exception {
        this.javaChannel().close();
        if (!this.ukcpChannel.closeAnother) {
            this.ukcpChannel.closeAnother = true;
            this.ukcpChannel.unsafe().close(this.ukcpChannel.unsafe().voidPromise());
        }
    }

    protected void doBeginRead() throws Exception {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doReadMessages(List<Object> buf) throws Exception {
        DatagramChannel ch = this.javaChannel();
        ChannelConfig config = this.config();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        ByteBuf data = allocHandle.allocate(config.getAllocator());
        allocHandle.attemptedBytesRead(data.writableBytes());
        boolean free = true;
        try {
            ByteBuffer nioData = data.internalNioBuffer(data.writerIndex(), data.writableBytes());
            int pos = nioData.position();
            int read = ch.read(nioData);
            if (read <= 0) {
                int n = read;
                return n;
            }
            allocHandle.lastBytesRead(nioData.position() - pos);
            buf.add(data.writerIndex(data.writerIndex() + allocHandle.lastBytesRead()));
            free = false;
            int n = 1;
            return n;
        }
        catch (Throwable cause) {
            PlatformDependent.throwException((Throwable)cause);
            int n = -1;
            return n;
        }
        finally {
            if (free) {
                data.release();
            }
        }
    }

    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        ByteBuf data = (ByteBuf)msg;
        int dataLen = data.readableBytes();
        if (dataLen == 0) {
            return true;
        }
        ByteBuffer nioData = data.internalNioBuffer(data.readerIndex(), dataLen);
        int writtenBytes = this.javaChannel().write(nioData);
        return writtenBytes > 0;
    }

    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UkcpClientUdpChannel.isSingleDirectBuffer(buf)) {
                return buf;
            }
            return this.newDirectBuffer(buf);
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf buf) {
        return buf.isDirect() && buf.nioBufferCount() == 1;
    }

    protected boolean continueOnWriteError() {
        return true;
    }

    private final class UkcpClientUdpUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf;

        private UkcpClientUdpUnsafe() {
            super((AbstractNioChannel)UkcpClientUdpChannel.this);
            this.readBuf = new ArrayList<Object>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read() {
            assert (UkcpClientUdpChannel.this.eventLoop().inEventLoop());
            ChannelConfig config = UkcpClientUdpChannel.this.config();
            ChannelPipeline pipeline = UkcpClientUdpChannel.this.pipeline();
            ChannelPipeline ukcpPipeline = UkcpClientUdpChannel.this.ukcpChannel.pipeline();
            RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            boolean closed = false;
            Throwable exception = null;
            try {
                try {
                    int localRead;
                    while ((localRead = UkcpClientUdpChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (localRead < 0) {
                            closed = true;
                        } else {
                            allocHandle.incMessagesRead(localRead);
                            if (allocHandle.continueReading()) continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                Throwable exception1 = null;
                int readBufSize = this.readBuf.size();
                try {
                    for (int i = 0; i < readBufSize; ++i) {
                        ByteBuf byteBuf = (ByteBuf)this.readBuf.get(i);
                        UkcpClientUdpChannel.this.ukcpChannel.kcpInput(byteBuf);
                    }
                    if (readBufSize > 0) {
                        UkcpClientUdpChannel.this.ukcpChannel.kcpTsUpdate(Utils.milliSeconds());
                    }
                }
                catch (Throwable t) {
                    exception1 = t;
                }
                if (exception1 == null && UkcpClientUdpChannel.this.ukcpChannel.kcpIsActive()) {
                    boolean mergeSegmentBuf = UkcpClientUdpChannel.this.ukcpChannel.config().isMergeSegmentBuf();
                    CodecOutputList<ByteBuf> recvBufList = null;
                    boolean recv = false;
                    try {
                        if (mergeSegmentBuf) {
                            int peekSize;
                            ByteBufAllocator allocator = config.getAllocator();
                            while ((peekSize = UkcpClientUdpChannel.this.ukcpChannel.kcpPeekSize()) >= 0) {
                                recv = true;
                                ByteBuf recvBuf = allocator.ioBuffer(peekSize);
                                UkcpClientUdpChannel.this.ukcpChannel.kcpReceive(recvBuf);
                                ukcpPipeline.fireChannelRead((Object)recvBuf);
                            }
                        } else {
                            while (UkcpClientUdpChannel.this.ukcpChannel.kcpCanRecv()) {
                                recv = true;
                                if (recvBufList == null) {
                                    recvBufList = CodecOutputList.newInstance();
                                }
                                UkcpClientUdpChannel.this.ukcpChannel.kcpReceive(recvBufList);
                            }
                        }
                    }
                    catch (Throwable t) {
                        exception1 = t;
                    }
                    if (recv) {
                        if (mergeSegmentBuf) {
                            ukcpPipeline.fireChannelReadComplete();
                        } else {
                            Utils.fireChannelRead(UkcpClientUdpChannel.this.ukcpChannel, recvBufList);
                            recvBufList.recycle();
                        }
                    }
                }
                this.clearAndReleaseReadBuf();
                allocHandle.readComplete();
                if (exception != null) {
                    closed = UkcpClientUdpChannel.this.closeOnReadError(exception);
                    ukcpPipeline.fireExceptionCaught(exception);
                }
                if (exception1 != null) {
                    closed = true;
                    ukcpPipeline.fireExceptionCaught(exception1);
                }
                if (closed) {
                    UkcpClientUdpChannel.this.inputShutdown = true;
                    if (UkcpClientUdpChannel.this.isOpen()) {
                        this.close(this.voidPromise());
                    }
                }
            }
            finally {
                if (!config.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }

        private void clearAndReleaseReadBuf() {
            int size = this.readBuf.size();
            for (int i = 0; i < size; ++i) {
                Object msg = this.readBuf.get(i);
                ReferenceCountUtil.release((Object)msg);
            }
            this.readBuf.clear();
        }
    }
}

