/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reflections8.Reflections;
import org.reflections8.ReflectionsException;
import org.reflections8.util.AlwaysTruePredicate;
import org.reflections8.util.ClasspathHelper;
import org.reflections8.util.Utils;

public abstract class ReflectionUtils {
    public static final boolean includeObject = false;
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> type2, Predicate<? super Class<?>> ... predicates) {
        LinkedHashSet result = new LinkedHashSet();
        if (type2 != null && !type2.equals(Object.class)) {
            result.add(type2);
            for (Class<?> supertype : ReflectionUtils.getSuperTypes(type2)) {
                result.addAll(ReflectionUtils.getAllSuperTypes(supertype, new Predicate[0]));
            }
        }
        return ReflectionUtils.filter(result, predicates);
    }

    public static Set<Class<?>> getSuperTypes(Class<?> type2) {
        LinkedHashSet result = new LinkedHashSet();
        Class<?> superclass = type2.getSuperclass();
        Class<?>[] interfaces = type2.getInterfaces();
        if (superclass != null && !superclass.equals(Object.class)) {
            result.add(superclass);
        }
        if (interfaces != null && interfaces.length > 0) {
            result.addAll(Arrays.asList(interfaces));
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type2, Predicate<? super Method> ... predicates) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type2, new Predicate[0])) {
            result.addAll(ReflectionUtils.getMethods(t, predicates));
        }
        return result;
    }

    public static Set<Method> getMethods(Class<?> t, Predicate<? super Method> ... predicates) {
        return ReflectionUtils.filter(t.isInterface() ? t.getMethods() : t.getDeclaredMethods(), predicates);
    }

    public static Set<Constructor> getAllConstructors(Class<?> type2, Predicate<? super Constructor> ... predicates) {
        HashSet<Constructor> result = new HashSet<Constructor>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type2, new Predicate[0])) {
            result.addAll(ReflectionUtils.getConstructors(t, predicates));
        }
        return result;
    }

    public static Set<Constructor> getConstructors(Class<?> t, Predicate<? super Constructor> ... predicates) {
        return ReflectionUtils.filter(t.getDeclaredConstructors(), predicates);
    }

    public static Set<Field> getAllFields(Class<?> type2, Predicate<? super Field> ... predicates) {
        HashSet<Field> result = new HashSet<Field>();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type2, new Predicate[0])) {
            result.addAll(ReflectionUtils.getFields(t, predicates));
        }
        return result;
    }

    public static Set<Field> getFields(Class<?> type2, Predicate<? super Field> ... predicates) {
        return ReflectionUtils.filter(type2.getDeclaredFields(), predicates);
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAllAnnotations(T type2, Predicate<Annotation> ... predicates) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (type2 instanceof Class) {
            for (Class<?> t : ReflectionUtils.getAllSuperTypes((Class)type2, new Predicate[0])) {
                result.addAll(ReflectionUtils.getAnnotations(t, predicates));
            }
        } else {
            result.addAll(ReflectionUtils.getAnnotations(type2, predicates));
        }
        return result;
    }

    public static <T extends AnnotatedElement> Set<Annotation> getAnnotations(T type2, Predicate<Annotation> ... predicates) {
        return ReflectionUtils.filter(type2.getDeclaredAnnotations(), predicates);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Set<T> elements, Predicate<? super T> ... predicates) {
        Predicate<? super T> p = new AlwaysTruePredicate<T>();
        for (Predicate<? super T> x : predicates) {
            p = p.and(x);
        }
        return Utils.isEmpty(predicates) ? elements : elements.stream().filter(p).collect(Collectors.toSet());
    }

    public static <T extends Member> Predicate<T> withName(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && input.getName().equals(name);
            }
        };
    }

    public static <T extends Member> Predicate<T> withPrefix(final String prefix) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && input.getName().startsWith(prefix);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withPattern(final String regex) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return Pattern.matches(regex, input.toString());
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && input.isAnnotationPresent(annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Class<? extends Annotation> ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && Arrays.equals(annotations, ReflectionUtils.annotationTypes(input.getAnnotations()));
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Annotation annotation) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && input.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(input.getAnnotation(annotation.annotationType()), annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Annotation ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                Annotation[] inputAnnotations;
                if (input != null && (inputAnnotations = input.getAnnotations()).length == annotations.length) {
                    for (int i2 = 0; i2 < inputAnnotations.length; ++i2) {
                        if (ReflectionUtils.areAnnotationMembersMatching(inputAnnotations[i2], annotations[i2])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Predicate<Member> withParameters(final Class<?> ... types) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return Arrays.equals(ReflectionUtils.parameterTypes(input), types);
            }
        };
    }

    public static Predicate<Member> withParametersAssignableTo(final Class ... types) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return ReflectionUtils.isAssignable(types, ReflectionUtils.parameterTypes(input));
            }
        };
    }

    public static Predicate<Member> withParametersAssignableFrom(final Class ... types) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return ReflectionUtils.isAssignable(ReflectionUtils.parameterTypes(input), types);
            }
        };
    }

    public static Predicate<Member> withParametersCount(final int count) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return input != null && ReflectionUtils.parameterTypes(input).length == count;
            }
        };
    }

    public static Predicate<Member> withAnyParameterAnnotation(final Class<? extends Annotation> annotationClass) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return input != null && ReflectionUtils.annotationTypes(ReflectionUtils.parameterAnnotations(input)).stream().anyMatch(new Predicate<Class<? extends Annotation>>(){

                    @Override
                    public boolean test(Class<? extends Annotation> predicateInput) {
                        return predicateInput.equals(annotationClass);
                    }
                });
            }
        };
    }

    public static Predicate<Member> withAnyParameterAnnotation(final Annotation annotation) {
        return new Predicate<Member>(){

            @Override
            public boolean test(Member input) {
                return input != null && ReflectionUtils.parameterAnnotations(input).stream().anyMatch(new Predicate<Annotation>(){

                    @Override
                    public boolean test(Annotation innerInput) {
                        return ReflectionUtils.areAnnotationMembersMatching(annotation, innerInput);
                    }
                });
            }
        };
    }

    public static <T> Predicate<Field> withType(final Class<T> type2) {
        return new Predicate<Field>(){

            @Override
            public boolean test(Field input) {
                return input != null && input.getType().equals(type2);
            }
        };
    }

    public static <T> Predicate<Field> withTypeAssignableTo(final Class<T> type2) {
        return new Predicate<Field>(){

            @Override
            public boolean test(Field input) {
                return input != null && type2.isAssignableFrom(input.getType());
            }
        };
    }

    public static <T> Predicate<Method> withReturnType(final Class<T> type2) {
        return new Predicate<Method>(){

            @Override
            public boolean test(Method input) {
                return input != null && input.getReturnType().equals(type2);
            }
        };
    }

    public static <T> Predicate<Method> withReturnTypeAssignableTo(final Class<T> type2) {
        return new Predicate<Method>(){

            @Override
            public boolean test(Method input) {
                return input != null && type2.isAssignableFrom(input.getReturnType());
            }
        };
    }

    public static <T extends Member> Predicate<T> withModifier(final int mod) {
        return new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return input != null && (input.getModifiers() & mod) != 0;
            }
        };
    }

    public static Predicate<Class<?>> withClassModifier(final int mod) {
        return new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> input) {
                return input != null && (input.getModifiers() & mod) != 0;
            }
        };
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        if (classLoaders == null) {
            return ReflectionUtils.forName(typeName, Optional.empty());
        }
        return ReflectionUtils.forName(typeName, Optional.of(classLoaders));
    }

    public static Class<?> forName(String typeName, Optional<ClassLoader[]> classLoaders) {
        String type2;
        if (ReflectionUtils.getPrimitiveNames().contains(typeName)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i2 = typeName.indexOf("[");
            type2 = typeName.substring(0, i2);
            String array = typeName.substring(i2).replace("]", "");
            type2 = ReflectionUtils.getPrimitiveNames().contains(type2) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(type2)) : "L" + type2 + ";";
            type2 = array + type2;
        } else {
            type2 = typeName;
        }
        ArrayList<ReflectionsException> reflectionsExceptions = new ArrayList<ReflectionsException>();
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders).get()) {
            if (type2.contains("[")) {
                try {
                    return Class.forName(type2, false, classLoader);
                }
                catch (Throwable e) {
                    reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
                }
            }
            try {
                return classLoader.loadClass(type2);
            }
            catch (Throwable e) {
                reflectionsExceptions.add(new ReflectionsException("could not get type for name " + typeName, e));
            }
        }
        if (Reflections.log.isPresent()) {
            for (ReflectionsException reflectionsException : reflectionsExceptions) {
                Reflections.log.get().warn("could not get type for name " + typeName + " from any class loader", (Throwable)reflectionsException);
            }
        }
        return null;
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, Optional<ClassLoader[]> classLoaders) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classes) {
            Class<?> type2 = ReflectionUtils.forName(className, classLoaders);
            if (type2 == null) continue;
            result.add(type2);
        }
        return result;
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        if (classLoaders == null) {
            return ReflectionUtils.forNames(classes, Optional.empty());
        }
        return ReflectionUtils.forNames(classes, Optional.of(classLoaders));
    }

    private static Class[] parameterTypes(Member member) {
        return member != null ? (member.getClass() == Method.class ? ((Method)member).getParameterTypes() : (member.getClass() == Constructor.class ? ((Constructor)member).getParameterTypes() : null)) : null;
    }

    private static Set<Annotation> parameterAnnotations(Member member) {
        Annotation[][] annotations;
        HashSet<Annotation> result = new HashSet<Annotation>();
        Annotation[][] annotationArray = member instanceof Method ? ((Method)member).getParameterAnnotations() : (annotations = member instanceof Constructor ? ((Constructor)member).getParameterAnnotations() : (Annotation[][])null);
        if (annotations != null) {
            for (Annotation[] annotation : annotations) {
                Collections.addAll(result, annotation);
            }
        }
        return result;
    }

    private static Set<Class<? extends Annotation>> annotationTypes(Iterable<Annotation> annotations) {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotations) {
            result.add(annotation.annotationType());
        }
        return result;
    }

    private static Class<? extends Annotation>[] annotationTypes(Annotation[] annotations) {
        Class[] result = new Class[annotations.length];
        for (int i2 = 0; i2 < annotations.length; ++i2) {
            result[i2] = annotations[i2].annotationType();
        }
        return result;
    }

    private static void initPrimitives() {
        if (primitiveNames == null) {
            primitiveNames = Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void");
            primitiveTypes = Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE);
            primitiveDescriptors = Arrays.asList("Z", "C", "B", "S", "I", "J", "F", "D", "V");
        }
    }

    private static List<String> getPrimitiveNames() {
        ReflectionUtils.initPrimitives();
        return primitiveNames;
    }

    private static List<Class> getPrimitiveTypes() {
        ReflectionUtils.initPrimitives();
        return primitiveTypes;
    }

    private static List<String> getPrimitiveDescriptors() {
        ReflectionUtils.initPrimitives();
        return primitiveDescriptors;
    }

    static <T> Predicate<? super T> andPredicateArray(Predicate<? super T>[] predicates) {
        Predicate<? super T> p = new AlwaysTruePredicate<T>();
        for (Predicate<? super T> x : predicates) {
            p = p.and(x);
        }
        return p;
    }

    static <T> Set<T> filter(T[] elements, Predicate<? super T> ... predicates) {
        Stream<? super T> elemStream = Arrays.stream(elements);
        return (Utils.isEmpty(predicates) ? elemStream : elemStream.filter(ReflectionUtils.andPredicateArray(predicates))).collect(Collectors.toSet());
    }

    static <T> Set<T> filter(Iterable<T> elements, Predicate<? super T> ... predicates) {
        Stream<? super T> elemStream = StreamSupport.stream(elements.spliterator(), false);
        return (Utils.isEmpty(predicates) ? elemStream : elemStream.filter(ReflectionUtils.andPredicateArray(predicates))).collect(Collectors.toSet());
    }

    private static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isAssignable(Class[] childClasses, Class[] parentClasses) {
        if (childClasses == null) {
            return parentClasses == null || parentClasses.length == 0;
        }
        if (childClasses.length != parentClasses.length) {
            return false;
        }
        for (int i2 = 0; i2 < childClasses.length; ++i2) {
            if (parentClasses[i2].isAssignableFrom(childClasses[i2]) && (parentClasses[i2] != Object.class || childClasses[i2] == Object.class)) continue;
            return false;
        }
        return true;
    }
}

