/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.order;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kcp.highway.threadPool.order.IOrderTask;
import kcp.highway.threadPool.order.OrderedThreadSession;
import kcp.highway.threadPool.order.waiteStrategy.BlockingWaitConditionStrategy;
import kcp.highway.threadPool.order.waiteStrategy.WaitCondition;
import kcp.highway.threadPool.order.waiteStrategy.WaitConditionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderedThreadPoolExecutor.class);
    private static final int DEFAULT_INITIAL_THREAD_POOL_SIZE = 0;
    private static final int DEFAULT_MAX_THREAD_POOL = 16;
    private static final int DEFAULT_KEEP_ALIVE = 30;
    private static final OrderedThreadSession EXIT_SIGNAL = new OrderedThreadSession();
    private final Queue<OrderedThreadSession> waitingSessions = new ConcurrentLinkedQueue<OrderedThreadSession>();
    private final WaitConditionStrategy waitConditionStrategy = new BlockingWaitConditionStrategy();
    private final Set<Worker> workers = new HashSet<Worker>();
    private volatile int largestPoolSize;
    private final AtomicInteger idleWorkers = new AtomicInteger();
    private long completedTaskCount;
    private volatile boolean shutdown;

    public OrderedThreadPoolExecutor() {
        this(0, 16, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory());
    }

    public OrderedThreadPoolExecutor(int maximumPoolSize) {
        this(0, maximumPoolSize, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory());
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS, Executors.defaultThreadFactory());
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        super(0, 1, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (maximumPoolSize <= 0 || maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        super.setMaximumPoolSize(maximumPoolSize);
        super.setCorePoolSize(corePoolSize);
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() >= super.getMaximumPoolSize()) {
                return;
            }
            Worker worker = new Worker();
            Thread thread = this.getThreadFactory().newThread(worker);
            this.idleWorkers.incrementAndGet();
            thread.start();
            this.workers.add(worker);
            if (this.workers.size() > this.largestPoolSize) {
                this.largestPoolSize = this.workers.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkerIfNecessary() {
        if (this.idleWorkers.get() == 0) {
            Set<Worker> set = this.workers;
            synchronized (set) {
                if (this.workers.isEmpty() || this.idleWorkers.get() == 0) {
                    this.addWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() <= super.getCorePoolSize()) {
                return;
            }
            this.waitingSessions.offer(EXIT_SIGNAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < super.getCorePoolSize()) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            super.setMaximumPoolSize(maximumPoolSize);
            for (int difference = this.workers.size() - maximumPoolSize; difference > 0; --difference) {
                this.removeWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        Set<Worker> set = this.workers;
        synchronized (set) {
            long waitTime;
            while (!this.isTerminated() && (waitTime = deadline - System.currentTimeMillis()) > 0L) {
                this.workers.wait(waitTime);
            }
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        if (!this.shutdown) {
            return false;
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i = this.workers.size(); i > 0; --i) {
                this.waitingSessions.offer(EXIT_SIGNAL);
            }
            this.waitConditionStrategy.signalAllWhenBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        OrderedThreadSession session;
        this.shutdown();
        ArrayList<Runnable> answer = new ArrayList<Runnable>();
        while ((session = this.waitingSessions.poll()) != null) {
            Queue<Runnable> queue;
            if (session == EXIT_SIGNAL) {
                this.waitingSessions.offer(EXIT_SIGNAL);
                Thread.yield();
                continue;
            }
            Queue<Runnable> queue2 = queue = session.getQueue();
            synchronized (queue2) {
                for (Runnable task : queue) {
                    answer.add(task);
                }
                queue.clear();
            }
        }
        return answer;
    }

    @Override
    public void execute(Runnable task) {
        IOrderTask event;
        OrderedThreadSession session;
        Queue<Runnable> tasksQueue;
        boolean offerSession;
        if (this.shutdown) {
            this.rejectTask(task);
        }
        if (!(offerSession = (tasksQueue = (session = (event = (IOrderTask)task).getSession()).getQueue()).offer(event))) {
            return;
        }
        boolean processing = this.offerWaitSession(session);
        if (!processing) {
            this.addWorkerIfNecessary();
        }
    }

    private boolean offerWaitSession(OrderedThreadSession session) {
        boolean processing = false;
        if (session.getProcessingCompleted().compareAndSet(true, false)) {
            this.waitingSessions.offer(session);
            processing = true;
        }
        this.waitConditionStrategy.signalAllWhenBlocking();
        return processing;
    }

    private void rejectTask(Runnable task) {
        this.getRejectedExecutionHandler().rejectedExecution(task, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size() - this.idleWorkers.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            long answer = this.completedTaskCount;
            for (Worker w : this.workers) {
                answer += w.completedTaskCount.get();
            }
            return answer;
        }
    }

    @Override
    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size();
        }
    }

    @Override
    public long getTaskCount() {
        return this.getCompletedTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminating() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.isShutdown() && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prestartAllCoreThreads() {
        int answer = 0;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i = super.getCorePoolSize() - this.workers.size(); i > 0; --i) {
                this.addWorker();
                ++answer;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prestartCoreThread() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() < super.getCorePoolSize()) {
                this.addWorker();
                return true;
            }
            return false;
        }
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purge() {
    }

    @Override
    public boolean remove(Runnable task) {
        IOrderTask event = (IOrderTask)task;
        OrderedThreadSession session = event.getSession();
        Queue<Runnable> tasksQueue = session.getQueue();
        return tasksQueue.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (corePoolSize > super.getMaximumPoolSize()) {
            throw new IllegalArgumentException("corePoolSize exceeds maximumPoolSize");
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (super.getCorePoolSize() > corePoolSize) {
                for (int i = super.getCorePoolSize() - corePoolSize; i > 0; --i) {
                    this.removeWorker();
                }
            }
            super.setCorePoolSize(corePoolSize);
        }
    }

    private class Worker
    implements Runnable,
    WaitCondition<OrderedThreadSession> {
        private AtomicLong completedTaskCount = new AtomicLong(0L);
        private Thread thread;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block30: {
                this.thread = Thread.currentThread();
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        session = null;
                        try {
                            session = OrderedThreadPoolExecutor.this.waitConditionStrategy.waitFor(this, OrderedThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        OrderedThreadPoolExecutor.this.idleWorkers.decrementAndGet();
                        try {
                            if (session == null) {
                                var2_4 = OrderedThreadPoolExecutor.this.workers;
                                synchronized (var2_4) {
                                    block29: {
                                        if (OrderedThreadPoolExecutor.this.workers.size() <= OrderedThreadPoolExecutor.this.getCorePoolSize()) break block29;
                                        OrderedThreadPoolExecutor.this.workers.remove(this);
                                        break block30;
                                    }
                                }
                            }
                            if (session != OrderedThreadPoolExecutor.EXIT_SIGNAL) {
                                this.runTasks((OrderedThreadSession)session);
                            }
                            break block30;
                        }
                        finally {
                            OrderedThreadPoolExecutor.this.idleWorkers.incrementAndGet();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block30;
                }
                finally {
                    var1_3 = OrderedThreadPoolExecutor.this.workers;
                    synchronized (var1_3) {
                        OrderedThreadPoolExecutor.this.workers.remove(this);
                        OrderedThreadPoolExecutor.this.completedTaskCount += this.completedTaskCount.get();
                        OrderedThreadPoolExecutor.this.workers.notifyAll();
                    }
                }
                ** GOTO lbl-1000
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OrderedThreadSession fetchSession() {
            OrderedThreadSession session = null;
            long currentTime = System.currentTimeMillis();
            long deadline = currentTime + OrderedThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.MILLISECONDS);
            while (true) {
                try {
                    long waitTime = deadline - currentTime;
                    if (waitTime <= 0L) break;
                    try {
                        session = OrderedThreadPoolExecutor.this.waitConditionStrategy.waitFor(this, waitTime, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        if (session != null) {
                            currentTime = System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            return session;
        }

        private void runTasks(OrderedThreadSession session) {
            int runTaskCount = session.getRunTaskCount();
            while (true) {
                Queue<Runnable> tasksQueue;
                Runnable task;
                if ((task = (tasksQueue = session.getQueue()).poll()) == null) break;
                this.runTask(task);
            }
            session.getProcessingCompleted().set(true);
        }

        private void runTask(Runnable task) {
            OrderedThreadPoolExecutor.this.beforeExecute(this.thread, task);
            boolean ran = false;
            try {
                task.run();
                ran = true;
                OrderedThreadPoolExecutor.this.afterExecute(task, null);
                this.completedTaskCount.incrementAndGet();
            }
            catch (RuntimeException e) {
                if (!ran) {
                    OrderedThreadPoolExecutor.this.afterExecute(task, e);
                }
                throw e;
            }
        }

        @Override
        public OrderedThreadSession getAttach() {
            return OrderedThreadPoolExecutor.this.waitingSessions.poll();
        }
    }
}

