/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;

public class UkcpPacket
extends AbstractReferenceCounted {
    private static final Recycler<UkcpPacket> RECYCLER = new Recycler<UkcpPacket>(){

        protected UkcpPacket newObject(Recycler.Handle<UkcpPacket> handle) {
            return new UkcpPacket(handle, null);
        }
    };
    private final Recycler.Handle<UkcpPacket> recyclerHandle;
    private ByteBuf content;
    private InetSocketAddress remoteAddress;

    public static UkcpPacket newInstance(ByteBuf content, InetSocketAddress remoteAddress) {
        UkcpPacket packet = (UkcpPacket)((Object)RECYCLER.get());
        packet.setRefCnt(1);
        packet.content = content;
        packet.remoteAddress = remoteAddress;
        return packet;
    }

    private UkcpPacket(Recycler.Handle<UkcpPacket> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.recyclerHandle.recycle((Object)this);
    }

    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public ByteBuf content() {
        return this.content;
    }

    protected void deallocate() {
        if (this.content != null) {
            this.content.release();
            this.content = null;
            this.remoteAddress = null;
            this.recycle();
        }
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    /* synthetic */ UkcpPacket(Recycler.Handle handle, UkcpPacket ukcpPacket) {
        this((Recycler.Handle<UkcpPacket>)handle);
    }
}

