/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.ITask;
import kcp.highway.threadPool.disruptor.DisruptorThread;
import kcp.highway.threadPool.disruptor.DistriptorEventFactory;
import kcp.highway.threadPool.disruptor.DistriptorEventHandler;
import kcp.highway.threadPool.disruptor.DistriptorHandler;

public class DisruptorSingleExecutor
implements IMessageExecutor {
    int ringBufferSize = 65536;
    private WaitStrategy strategy = new BlockingWaitStrategy();
    private Disruptor<DistriptorHandler> disruptor = null;
    private RingBuffer<DistriptorHandler> buffer = null;
    private DistriptorEventFactory eventFactory = new DistriptorEventFactory();
    private static final DistriptorEventHandler HANDLER = new DistriptorEventHandler();
    private AtomicBoolean istop = new AtomicBoolean();
    private String threadName;
    private DisruptorThread currentThread;
    static int num = 1;
    static long start = System.currentTimeMillis();
    static long lastNum = 0L;

    public DisruptorSingleExecutor(String threadName) {
        this.threadName = threadName;
    }

    public void start() {
        LoopThreadfactory loopThreadfactory = new LoopThreadfactory(this);
        this.disruptor = new Disruptor<DistriptorHandler>(this.eventFactory, this.ringBufferSize, loopThreadfactory);
        this.buffer = this.disruptor.getRingBuffer();
        this.disruptor.handleEventsWith(HANDLER);
        this.disruptor.start();
    }

    @Override
    public void stop() {
        if (this.istop.get()) {
            return;
        }
        this.disruptor.shutdown();
        this.istop.set(true);
    }

    public static void main(String[] args) {
        DisruptorSingleExecutor disruptorSingleExecutor = new DisruptorSingleExecutor("aa");
        disruptorSingleExecutor.start();
        disruptorSingleExecutor.execute(() -> System.out.println("hahaha"));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public AtomicBoolean getIstop() {
        return this.istop;
    }

    @Override
    public boolean isFull() {
        return !this.buffer.hasAvailableCapacity(1);
    }

    @Override
    public void execute(ITask iTask) {
        Thread currentThread = Thread.currentThread();
        long next = this.buffer.next();
        DistriptorHandler testEvent = this.buffer.get(next);
        testEvent.setTask(iTask);
        this.buffer.publish(next);
    }

    private class LoopThreadfactory
    implements ThreadFactory {
        IMessageExecutor iMessageExecutor;

        public LoopThreadfactory(IMessageExecutor iMessageExecutor) {
            this.iMessageExecutor = iMessageExecutor;
        }

        @Override
        public Thread newThread(Runnable r) {
            DisruptorSingleExecutor.this.currentThread = new DisruptorThread(r, this.iMessageExecutor);
            DisruptorSingleExecutor.this.currentThread.setName(DisruptorSingleExecutor.this.threadName);
            return DisruptorSingleExecutor.this.currentThread;
        }
    }
}

