/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.Recycler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedList;
import java.util.List;
import kcp.highway.IKcp;
import kcp.highway.KcpOutput;
import kcp.highway.User;
import kcp.highway.erasure.fec.Snmp;
import kcp.highway.internal.ReItrLinkedList;
import kcp.highway.internal.ReusableIterator;
import kcp.highway.internal.ReusableListIterator;

public class Kcp
implements IKcp {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Kcp.class);
    public static final int IKCP_RTO_NDL = 30;
    public static final int IKCP_RTO_MIN = 100;
    public static final int IKCP_RTO_DEF = 200;
    public static final int IKCP_RTO_MAX = 60000;
    public static final byte IKCP_CMD_PUSH = 81;
    public static final byte IKCP_CMD_ACK = 82;
    public static final byte IKCP_CMD_WASK = 83;
    public static final byte IKCP_CMD_WINS = 84;
    public static final int IKCP_ASK_SEND = 1;
    public static final int IKCP_ASK_TELL = 2;
    public static final int IKCP_WND_SND = 256;
    public static final int IKCP_WND_RCV = 256;
    public static final int IKCP_MTU_DEF = 1400;
    public static final int IKCP_INTERVAL = 100;
    public int IKCP_OVERHEAD = 28;
    public static final int IKCP_DEADLINK = 20;
    public static final int IKCP_THRESH_INIT = 2;
    public static final int IKCP_THRESH_MIN = 2;
    public static final int IKCP_PROBE_INIT = 7000;
    public static final int IKCP_PROBE_LIMIT = 120000;
    public static final int IKCP_SN_OFFSET = 16;
    private int ackMaskSize = 0;
    private long conv;
    private int mtu = 1400;
    private int mss = this.mtu - this.IKCP_OVERHEAD;
    private int state;
    private long sndUna;
    private long sndNxt;
    private long rcvNxt;
    private long tsLastack;
    private int ssthresh = 2;
    private int rxRttval;
    private int rxSrtt;
    private int rxRto = 200;
    private int rxMinrto = 100;
    private int sndWnd = 256;
    private int rcvWnd = 256;
    private int rmtWnd = 256;
    private int cwnd;
    private int probe;
    private int interval = 100;
    private long tsFlush = 100L;
    private boolean nodelay;
    private boolean updated;
    private long tsProbe;
    private int probeWait;
    private int deadLink = 20;
    private int incr;
    private boolean ackNoDelay;
    private LinkedList<Segment> sndQueue = new LinkedList();
    private ReItrLinkedList<Segment> sndBuf = new ReItrLinkedList();
    private ReItrLinkedList<Segment> rcvQueue = new ReItrLinkedList();
    private ReItrLinkedList<Segment> rcvBuf = new ReItrLinkedList();
    private ReusableListIterator<Segment> rcvQueueItr = this.rcvQueue.listIterator();
    public ReusableListIterator<Segment> sndBufItr = this.sndBuf.listIterator();
    private ReusableListIterator<Segment> rcvBufItr = this.rcvBuf.listIterator();
    private long[] acklist = new long[8];
    private int ackcount;
    private User user;
    private int fastresend;
    private boolean nocwnd;
    private boolean stream;
    private int reserved;
    private KcpOutput output;
    private ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
    private long ackMask;
    private long lastRcvNxt;
    private long startTicks = System.currentTimeMillis();

    private static long long2Uint(long n) {
        return n & 0xFFFFFFFFL;
    }

    private static int ibound(int lower, int middle, int upper) {
        return Math.min(Math.max(lower, middle), upper);
    }

    private static int itimediff(long later, long earlier) {
        return (int)(later - earlier);
    }

    private static void output(ByteBuf data, Kcp kcp) {
        if (log.isDebugEnabled()) {
            log.debug("{} [RO] {} bytes", (Object)kcp, (Object)data.readableBytes());
        }
        if (data.readableBytes() == 0) {
            return;
        }
        kcp.output.out(data, kcp);
    }

    private static int encodeSeg(ByteBuf buf, Segment seg) {
        int offset = buf.writerIndex();
        buf.writeLong(seg.conv);
        buf.writeByte((int)seg.cmd);
        buf.writeByte((int)seg.frg);
        buf.writeShortLE(seg.wnd);
        buf.writeIntLE((int)seg.ts);
        buf.writeIntLE((int)seg.sn);
        buf.writeIntLE((int)seg.una);
        int dataSize = seg.data == null ? 0 : seg.data.readableBytes();
        buf.writeIntLE(dataSize);
        switch (seg.ackMaskSize) {
            case 8: {
                buf.writeByte((int)seg.ackMask);
                break;
            }
            case 16: {
                buf.writeShortLE((int)seg.ackMask);
                break;
            }
            case 32: {
                buf.writeIntLE((int)seg.ackMask);
                break;
            }
            case 64: {
                buf.writeLongLE(seg.ackMask);
            }
        }
        Snmp.snmp.OutSegs.increment();
        return buf.writerIndex() - offset;
    }

    public Kcp(long conv, KcpOutput output) {
        this.conv = conv;
        this.output = output;
    }

    @Override
    public void release() {
        this.release(this.sndBuf);
        this.release(this.rcvBuf);
        this.release(this.sndQueue);
        this.release(this.rcvQueue);
    }

    private void release(List<Segment> segQueue) {
        for (Segment seg : segQueue) {
            seg.recycle(true);
        }
    }

    private ByteBuf createFlushByteBuf() {
        return this.byteBufAllocator.ioBuffer(this.mtu);
    }

    @Override
    public ByteBuf mergeRecv() {
        if (this.rcvQueue.isEmpty()) {
            return null;
        }
        int peekSize = this.peekSize();
        if (peekSize < 0) {
            return null;
        }
        boolean recover = false;
        if (this.rcvQueue.size() >= this.rcvWnd) {
            recover = true;
        }
        ByteBuf byteBuf = null;
        int len = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            len += seg.data.readableBytes();
            short fragment = seg.frg;
            itr.remove();
            if (log.isDebugEnabled()) {
                log.debug("{} recv sn={}", (Object)this, (Object)seg.sn);
            }
            if (byteBuf == null) {
                if (fragment == 0) {
                    byteBuf = seg.data;
                    seg.recycle(false);
                    break;
                }
                byteBuf = this.byteBufAllocator.ioBuffer(len);
            }
            byteBuf.writeBytes(seg.data);
            seg.recycle(true);
            if (fragment != 0) continue;
            break;
        }
        assert (len == peekSize);
        this.moveRcvData();
        if (this.rcvQueue.size() < this.rcvWnd && recover) {
            this.probe |= 2;
        }
        return byteBuf;
    }

    @Override
    public int recv(List<ByteBuf> bufList) {
        if (this.rcvQueue.isEmpty()) {
            return -1;
        }
        int peekSize = this.peekSize();
        if (peekSize < 0) {
            return -2;
        }
        boolean recover = false;
        if (this.rcvQueue.size() >= this.rcvWnd) {
            recover = true;
        }
        int len = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            len += seg.data.readableBytes();
            bufList.add(seg.data);
            short fragment = seg.frg;
            if (log.isDebugEnabled()) {
                log.debug("{} recv sn={}", (Object)this, (Object)seg.sn);
            }
            itr.remove();
            seg.recycle(false);
            if (fragment != 0) continue;
            break;
        }
        assert (len == peekSize);
        this.moveRcvData();
        if (this.rcvQueue.size() < this.rcvWnd && recover) {
            this.probe |= 2;
        }
        return len;
    }

    @Override
    public int peekSize() {
        if (this.rcvQueue.isEmpty()) {
            return -1;
        }
        Segment seg = this.rcvQueue.peek();
        if (seg.frg == 0) {
            return seg.data.readableBytes();
        }
        if (this.rcvQueue.size() < seg.frg + 1) {
            return -1;
        }
        int len = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment s = (Segment)itr.next();
            len += s.data.readableBytes();
            if (s.frg != 0) continue;
            break;
        }
        return len;
    }

    @Override
    public boolean canRecv() {
        if (this.rcvQueue.isEmpty()) {
            return false;
        }
        Segment seg = this.rcvQueue.peek();
        if (seg.frg == 0) {
            return true;
        }
        return this.rcvQueue.size() >= seg.frg + 1;
    }

    @Override
    public int send(ByteBuf buf) {
        int count;
        assert (this.mss > 0);
        int len = buf.readableBytes();
        if (len == 0) {
            return -1;
        }
        if (this.stream && !this.sndQueue.isEmpty()) {
            Segment last = this.sndQueue.peekLast();
            ByteBuf lastData = last.data;
            int lastLen = lastData.readableBytes();
            if (lastLen < this.mss) {
                int extend;
                int capacity = this.mss - lastLen;
                int n = extend = len < capacity ? len : capacity;
                if (lastData.maxWritableBytes() < extend) {
                    ByteBuf newBuf = this.byteBufAllocator.ioBuffer(lastLen + extend);
                    newBuf.writeBytes(lastData);
                    lastData.release();
                    lastData = last.data = newBuf;
                }
                lastData.writeBytes(buf, extend);
                len = buf.readableBytes();
                if (len == 0) {
                    return 0;
                }
            }
        }
        if ((count = len <= this.mss ? 1 : (len + this.mss - 1) / this.mss) > 255) {
            return -2;
        }
        if (count == 0) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            int size = len > this.mss ? this.mss : len;
            Segment seg = Segment.createSegment(buf.readRetainedSlice(size));
            seg.frg = (short)(this.stream ? 0 : count - i - 1);
            this.sndQueue.add(seg);
            len = buf.readableBytes();
        }
        return 0;
    }

    private void updateAck(int rtt) {
        if (this.rxSrtt == 0) {
            this.rxSrtt = rtt;
            this.rxRttval = rtt >> 2;
        } else {
            int delta = rtt - this.rxSrtt;
            this.rxSrtt += delta >> 3;
            delta = Math.abs(delta);
            this.rxRttval = rtt < this.rxSrtt - this.rxRttval ? (this.rxRttval += delta - this.rxRttval >> 5) : (this.rxRttval += delta - this.rxRttval >> 2);
        }
        int rto = this.rxSrtt + Math.max(this.interval, this.rxRttval << 2);
        this.rxRto = Kcp.ibound(this.rxMinrto, rto, 60000);
    }

    private void shrinkBuf() {
        if (this.sndBuf.size() > 0) {
            Segment seg = this.sndBuf.peek();
            this.sndUna = seg.sn;
        } else {
            this.sndUna = this.sndNxt;
        }
    }

    private void parseAck(long sn) {
        if (Kcp.itimediff(sn, this.sndUna) < 0 || Kcp.itimediff(sn, this.sndNxt) >= 0) {
            return;
        }
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (sn == seg.sn) {
                itr.remove();
                seg.recycle(true);
                break;
            }
            if (Kcp.itimediff(sn, seg.sn) >= 0) continue;
            break;
        }
    }

    private int parseUna(long una) {
        int count = 0;
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (Kcp.itimediff(una, seg.sn) <= 0) break;
            ++count;
            itr.remove();
            seg.recycle(true);
        }
        return count;
    }

    private void parseAckMask(long una, long ackMask) {
        if (ackMask == 0L) {
            return;
        }
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            long index = seg.sn - una - 1L;
            if (index < 0L) continue;
            if (index >= (long)this.ackMaskSize) break;
            long mask = ackMask & (long)(1 << (int)index);
            if (mask == 0L) continue;
            itr.remove();
            seg.recycle(true);
        }
    }

    private void parseFastack(long sn, long ts) {
        if (Kcp.itimediff(sn, this.sndUna) < 0 || Kcp.itimediff(sn, this.sndNxt) >= 0) {
            return;
        }
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (Kcp.itimediff(sn, seg.sn) < 0) break;
            if (sn == seg.sn || Kcp.itimediff(seg.ts, ts) > 0) continue;
            ++seg.fastack;
        }
    }

    private void ackPush(long sn, long ts) {
        int newSize = 2 * (this.ackcount + 1);
        if (newSize > this.acklist.length) {
            int newCapacity = this.acklist.length << 1;
            if (newCapacity < 0) {
                throw new OutOfMemoryError();
            }
            long[] newArray = new long[newCapacity];
            System.arraycopy(this.acklist, 0, newArray, 0, this.acklist.length);
            this.acklist = newArray;
        }
        this.acklist[2 * this.ackcount] = sn;
        this.acklist[2 * this.ackcount + 1] = ts;
        ++this.ackcount;
    }

    private boolean parseData(Segment newSeg) {
        long sn = newSeg.sn;
        if (Kcp.itimediff(sn, this.rcvNxt + (long)this.rcvWnd) >= 0 || Kcp.itimediff(sn, this.rcvNxt) < 0) {
            newSeg.recycle(true);
            return true;
        }
        boolean repeat = false;
        boolean findPos = false;
        ReusableListIterator<Segment> listItr = null;
        if (this.rcvBuf.size() > 0) {
            listItr = this.rcvBufItr.rewind(this.rcvBuf.size());
            while (listItr.hasPrevious()) {
                Segment seg = (Segment)listItr.previous();
                if (seg.sn == sn) {
                    repeat = true;
                    break;
                }
                if (Kcp.itimediff(sn, seg.sn) <= 0) continue;
                findPos = true;
                break;
            }
        }
        if (repeat) {
            newSeg.recycle(true);
        } else if (listItr == null) {
            this.rcvBuf.add(newSeg);
        } else {
            if (findPos) {
                listItr.next();
            }
            listItr.add(newSeg);
        }
        this.moveRcvData();
        return repeat;
    }

    private void moveRcvData() {
        ReusableIterator itr = this.rcvBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (seg.sn != this.rcvNxt || this.rcvQueue.size() >= this.rcvWnd) break;
            itr.remove();
            this.rcvQueue.add(seg);
            ++this.rcvNxt;
        }
    }

    @Override
    public int input(ByteBuf data, boolean regular, long current) {
        int rtt;
        long oldSndUna = this.sndUna;
        if (data == null || data.readableBytes() < this.IKCP_OVERHEAD) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug("{} [RI] {} bytes", (Object)this, (Object)data.readableBytes());
        }
        long latest = 0L;
        boolean flag = false;
        int inSegs = 0;
        boolean windowSlides = false;
        long uintCurrent = Kcp.long2Uint(this.currentMs(current));
        while (data.readableBytes() >= this.IKCP_OVERHEAD) {
            long ackMask;
            long conv = data.readLong();
            if (conv != this.conv) {
                return -4;
            }
            byte cmd = data.readByte();
            short frg = data.readUnsignedByte();
            int wnd = data.readUnsignedShortLE();
            long ts = data.readIntLE();
            long sn = data.readUnsignedIntLE();
            long una = data.readUnsignedIntLE();
            int len = data.readIntLE();
            switch (this.ackMaskSize) {
                case 8: {
                    long l = data.readUnsignedByte();
                    break;
                }
                case 16: {
                    long l = data.readUnsignedShortLE();
                    break;
                }
                case 32: {
                    long l = data.readUnsignedIntLE();
                    break;
                }
                case 64: {
                    long l = data.readLongLE();
                    break;
                }
                default: {
                    long l = ackMask = 0L;
                }
            }
            if (data.readableBytes() < len || len < 0) {
                return -2;
            }
            if (cmd != 81 && cmd != 82 && cmd != 83 && cmd != 84) {
                return -3;
            }
            if (regular) {
                this.rmtWnd = wnd;
            }
            if (this.parseUna(una) > 0) {
                windowSlides = true;
            }
            this.shrinkBuf();
            boolean readed = false;
            switch (cmd) {
                case 82: {
                    this.parseAck(sn);
                    this.parseFastack(sn, ts);
                    flag = true;
                    latest = ts;
                    int rtt2 = Kcp.itimediff(uintCurrent, ts);
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input ack: sn={}, rtt={}, rto={} ,regular={} ts={}", new Object[]{this, sn, rtt2, this.rxRto, regular, ts});
                    break;
                }
                case 81: {
                    boolean repeat = true;
                    if (Kcp.itimediff(sn, this.rcvNxt + (long)this.rcvWnd) < 0) {
                        this.ackPush(sn, ts);
                        if (Kcp.itimediff(sn, this.rcvNxt) >= 0) {
                            Segment seg;
                            if (len > 0) {
                                seg = Segment.createSegment(data.readRetainedSlice(len));
                                readed = true;
                            } else {
                                seg = Segment.createSegment(this.byteBufAllocator, 0);
                            }
                            seg.conv = conv;
                            seg.cmd = cmd;
                            seg.frg = frg;
                            seg.wnd = wnd;
                            seg.ts = ts;
                            seg.sn = sn;
                            seg.una = una;
                            repeat = this.parseData(seg);
                        }
                    }
                    if (regular && repeat) {
                        Snmp.snmp.RepeatSegs.increment();
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input push: sn={}, una={}, ts={},regular={}", new Object[]{this, sn, una, ts, regular});
                    break;
                }
                case 83: {
                    this.probe |= 2;
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input ask", (Object)this);
                    break;
                }
                case 84: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input tell: {}", (Object)this, (Object)wnd);
                    break;
                }
                default: {
                    return -3;
                }
            }
            this.parseAckMask(una, ackMask);
            if (!readed) {
                data.skipBytes(len);
            }
            ++inSegs;
        }
        Snmp.snmp.InSegs.add(inSegs);
        if (flag && regular && (rtt = Kcp.itimediff(uintCurrent, latest)) >= 0) {
            this.updateAck(rtt);
        }
        if (!this.nocwnd && Kcp.itimediff(this.sndUna, oldSndUna) > 0 && this.cwnd < this.rmtWnd) {
            int mss = this.mss;
            if (this.cwnd < this.ssthresh) {
                ++this.cwnd;
                this.incr += mss;
            } else {
                if (this.incr < mss) {
                    this.incr = mss;
                }
                this.incr += mss * mss / this.incr + mss / 16;
                if ((this.cwnd + 1) * mss <= this.incr) {
                    this.cwnd = mss > 0 ? (this.incr + mss - 1) / mss : this.incr + mss - 1;
                }
            }
            if (this.cwnd > this.rmtWnd) {
                this.cwnd = this.rmtWnd;
                this.incr = this.rmtWnd * mss;
            }
        }
        return 0;
    }

    private int wndUnused() {
        if (this.rcvQueue.size() < this.rcvWnd) {
            return this.rcvWnd - this.rcvQueue.size();
        }
        return 0;
    }

    private ByteBuf makeSpace(ByteBuf buffer, int space) {
        if (buffer == null) {
            buffer = this.createFlushByteBuf();
            buffer.writerIndex(this.reserved);
        } else if (buffer.readableBytes() + space > this.mtu) {
            Kcp.output(buffer, this);
            buffer = this.createFlushByteBuf();
            buffer.writerIndex(this.reserved);
        }
        return buffer;
    }

    private void flushBuffer(ByteBuf buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.readableBytes() > this.reserved) {
            Kcp.output(buffer, this);
            return;
        }
        buffer.release();
    }

    @Override
    public long currentMs(long now) {
        return now - this.startTicks;
    }

    @Override
    public long flush(boolean ackOnly, long current) {
        Segment newSeg;
        long sn;
        int i;
        current = this.currentMs(current);
        Segment seg = Segment.createSegment(this.byteBufAllocator, 0);
        seg.conv = this.conv;
        seg.cmd = (byte)82;
        seg.ackMaskSize = this.ackMaskSize;
        seg.wnd = this.wndUnused();
        seg.una = this.rcvNxt;
        ByteBuf buffer = null;
        int count = this.ackcount;
        if (this.lastRcvNxt != this.rcvNxt) {
            this.ackMask = 0L;
            this.lastRcvNxt = this.rcvNxt;
        }
        for (i = 0; i < count; ++i) {
            sn = this.acklist[i * 2];
            if (sn < this.rcvNxt) continue;
            long index = sn - this.rcvNxt - 1L;
            if (index >= (long)this.ackMaskSize) break;
            if (index < 0L) continue;
            this.ackMask |= (long)(1 << (int)index);
        }
        seg.ackMask = this.ackMask;
        for (i = 0; i < count; ++i) {
            sn = this.acklist[i * 2];
            if (Kcp.itimediff(sn, this.rcvNxt) < 0 && count - 1 != i) continue;
            buffer = this.makeSpace(buffer, this.IKCP_OVERHEAD);
            seg.sn = sn;
            seg.ts = this.acklist[i * 2 + 1];
            Kcp.encodeSeg(buffer, seg);
            if (!log.isDebugEnabled()) continue;
            log.debug("{} flush ack: sn={}, ts={} ,count={}", new Object[]{this, seg.sn, seg.ts, count});
        }
        this.ackcount = 0;
        if (ackOnly) {
            this.flushBuffer(buffer);
            seg.recycle(true);
            return this.interval;
        }
        if (this.rmtWnd == 0) {
            if (this.probeWait == 0) {
                this.probeWait = 7000;
                this.tsProbe = current + (long)this.probeWait;
            } else if (Kcp.itimediff(current, this.tsProbe) >= 0) {
                if (this.probeWait < 7000) {
                    this.probeWait = 7000;
                }
                this.probeWait += this.probeWait / 2;
                if (this.probeWait > 120000) {
                    this.probeWait = 120000;
                }
                this.tsProbe = current + (long)this.probeWait;
                this.probe |= 1;
            }
        } else {
            this.tsProbe = 0L;
            this.probeWait = 0;
        }
        if ((this.probe & 1) != 0) {
            seg.cmd = (byte)83;
            buffer = this.makeSpace(buffer, this.IKCP_OVERHEAD);
            Kcp.encodeSeg(buffer, seg);
            if (log.isDebugEnabled()) {
                log.debug("{} flush ask", (Object)this);
            }
        }
        if ((this.probe & 2) != 0) {
            seg.cmd = (byte)84;
            buffer = this.makeSpace(buffer, this.IKCP_OVERHEAD);
            Kcp.encodeSeg(buffer, seg);
            if (log.isDebugEnabled()) {
                log.debug("{} flush tell: wnd={}", (Object)this, (Object)seg.wnd);
            }
        }
        this.probe = 0;
        int cwnd0 = Math.min(this.sndWnd, this.rmtWnd);
        if (!this.nocwnd) {
            cwnd0 = Math.min(this.cwnd, cwnd0);
        }
        int newSegsCount = 0;
        while (Kcp.itimediff(this.sndNxt, this.sndUna + (long)cwnd0) < 0 && (newSeg = this.sndQueue.poll()) != null) {
            newSeg.conv = this.conv;
            newSeg.cmd = (byte)81;
            newSeg.sn = this.sndNxt++;
            this.sndBuf.add(newSeg);
            ++newSegsCount;
        }
        int resent = this.fastresend > 0 ? this.fastresend : Integer.MAX_VALUE;
        int change = 0;
        boolean lost = false;
        int lostSegs = 0;
        int fastRetransSegs = 0;
        int earlyRetransSegs = 0;
        long minrto = this.interval;
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            long rto;
            Segment segment = (Segment)itr.next();
            boolean needsend = false;
            if (segment.xmit == 0) {
                needsend = true;
                segment.rto = this.rxRto;
                segment.resendts = current + (long)segment.rto;
                if (log.isDebugEnabled()) {
                    log.debug("{} flush data: sn={}, resendts={}", new Object[]{this, segment.sn, segment.resendts - current});
                }
            } else if (segment.fastack >= resent) {
                needsend = true;
                segment.fastack = 0;
                segment.rto = this.rxRto;
                segment.resendts = current + (long)segment.rto;
                ++change;
                ++fastRetransSegs;
                if (log.isDebugEnabled()) {
                    log.debug("{} fastresend. sn={}, xmit={}, resendts={} ", new Object[]{this, segment.sn, segment.xmit, segment.resendts - current});
                }
            } else if (segment.fastack > 0 && newSegsCount == 0) {
                needsend = true;
                segment.fastack = 0;
                segment.rto = this.rxRto;
                segment.resendts = current + (long)segment.rto;
                ++change;
                ++earlyRetransSegs;
            } else if (Kcp.itimediff(current, segment.resendts) >= 0) {
                needsend = true;
                segment.rto = !this.nodelay ? (segment.rto += this.rxRto) : (segment.rto += this.rxRto / 2);
                segment.fastack = 0;
                segment.resendts = current + (long)segment.rto;
                lost = true;
                ++lostSegs;
                if (log.isDebugEnabled()) {
                    log.debug("{} resend. sn={}, xmit={}, resendts={}", new Object[]{this, segment.sn, segment.xmit, segment.resendts - current});
                }
            }
            if (!needsend) continue;
            ++segment.xmit;
            segment.ts = Kcp.long2Uint(current);
            segment.wnd = seg.wnd;
            segment.una = this.rcvNxt;
            segment.ackMaskSize = this.ackMaskSize;
            segment.ackMask = this.ackMask;
            ByteBuf segData = segment.data;
            int segLen = segData.readableBytes();
            int need = this.IKCP_OVERHEAD + segLen;
            buffer = this.makeSpace(buffer, need);
            Kcp.encodeSeg(buffer, segment);
            if (segLen > 0) {
                buffer.writeBytes(segData, segData.readerIndex(), segLen);
            }
            if ((rto = (long)Kcp.itimediff(segment.resendts, current)) <= 0L || rto >= minrto) continue;
            minrto = rto;
        }
        this.flushBuffer(buffer);
        seg.recycle(true);
        int sum = lostSegs;
        if (lostSegs > 0) {
            Snmp.snmp.LostSegs.add(lostSegs);
        }
        if (fastRetransSegs > 0) {
            Snmp.snmp.FastRetransSegs.add(fastRetransSegs);
            sum += fastRetransSegs;
        }
        if (earlyRetransSegs > 0) {
            Snmp.snmp.EarlyRetransSegs.add(earlyRetransSegs);
            sum += earlyRetransSegs;
        }
        if (sum > 0) {
            Snmp.snmp.RetransSegs.add(sum);
        }
        if (!this.nocwnd) {
            if (change > 0) {
                int inflight = (int)(this.sndNxt - this.sndUna);
                this.ssthresh = inflight / 2;
                if (this.ssthresh < 2) {
                    this.ssthresh = 2;
                }
                this.cwnd = this.ssthresh + resent;
                this.incr = this.cwnd * this.mss;
            }
            if (lost) {
                this.ssthresh = cwnd0 / 2;
                if (this.ssthresh < 2) {
                    this.ssthresh = 2;
                }
                this.cwnd = 1;
                this.incr = this.mss;
            }
            if (this.cwnd < 1) {
                this.cwnd = 1;
                this.incr = this.mss;
            }
        }
        return minrto;
    }

    @Override
    public void update(long current) {
        int slap;
        if (!this.updated) {
            this.updated = true;
            this.tsFlush = current;
        }
        if ((slap = Kcp.itimediff(current, this.tsFlush)) >= 10000 || slap < -10000) {
            this.tsFlush = current;
            slap = 0;
        }
        if (slap >= 0) {
            this.tsFlush += (long)this.interval;
            if (Kcp.itimediff(current, this.tsFlush) >= 0) {
                this.tsFlush = current + (long)this.interval;
            }
        } else {
            this.tsFlush = current + (long)this.interval;
        }
        this.flush(false, current);
    }

    @Override
    public long check(long current) {
        int minimal;
        if (!this.updated) {
            return current;
        }
        long tsFlush = this.tsFlush;
        int slap = Kcp.itimediff(current, tsFlush);
        if (slap >= 10000 || slap < -10000) {
            tsFlush = current;
            slap = 0;
        }
        if (slap >= 0) {
            return current;
        }
        int tmFlush = Kcp.itimediff(tsFlush, current);
        int tmPacket = Integer.MAX_VALUE;
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            int diff = Kcp.itimediff(seg.resendts, current);
            if (diff <= 0) {
                return current;
            }
            if (diff >= tmPacket) continue;
            tmPacket = diff;
        }
        int n = minimal = tmPacket < tmFlush ? tmPacket : tmFlush;
        if (minimal >= this.interval) {
            minimal = this.interval;
        }
        return current + (long)minimal;
    }

    @Override
    public boolean checkFlush() {
        if (this.ackcount > 0) {
            return true;
        }
        if (this.probe != 0) {
            return true;
        }
        if (this.sndBuf.size() > 0) {
            return true;
        }
        return this.sndQueue.size() > 0;
    }

    @Override
    public int setMtu(int mtu) {
        if (mtu < this.IKCP_OVERHEAD || mtu < 50) {
            return -1;
        }
        if (this.reserved >= mtu - this.IKCP_OVERHEAD || this.reserved < 0) {
            return -1;
        }
        this.mtu = mtu;
        this.mss = mtu - this.IKCP_OVERHEAD - this.reserved;
        return 0;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public int nodelay(boolean nodelay, int interval, int resend, boolean nc) {
        this.nodelay = nodelay;
        this.rxMinrto = nodelay ? 30 : 100;
        if (interval >= 0) {
            if (interval > 5000) {
                interval = 5000;
            } else if (interval < 10) {
                interval = 10;
            }
            this.interval = interval;
        }
        if (resend >= 0) {
            this.fastresend = resend;
        }
        this.nocwnd = nc;
        return 0;
    }

    @Override
    public int waitSnd() {
        return this.sndBuf.size() + this.sndQueue.size();
    }

    @Override
    public long getConv() {
        return this.conv;
    }

    @Override
    public void setConv(long conv) {
        this.conv = conv;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public boolean isNodelay() {
        return this.nodelay;
    }

    @Override
    public void setNodelay(boolean nodelay) {
        this.nodelay = nodelay;
        this.rxMinrto = nodelay ? 30 : 100;
    }

    @Override
    public void setFastresend(int fastresend) {
        this.fastresend = fastresend;
    }

    @Override
    public void setRxMinrto(int rxMinrto) {
        this.rxMinrto = rxMinrto;
    }

    @Override
    public void setRcvWnd(int rcvWnd) {
        this.rcvWnd = rcvWnd;
    }

    @Override
    public void setAckMaskSize(int ackMaskSize) {
        this.ackMaskSize = ackMaskSize;
        this.IKCP_OVERHEAD += ackMaskSize / 8;
        this.mss = this.mtu - this.IKCP_OVERHEAD - this.reserved;
    }

    @Override
    public void setReserved(int reserved) {
        this.reserved = reserved;
        this.mss = this.mtu - this.IKCP_OVERHEAD - reserved;
    }

    @Override
    public int getSndWnd() {
        return this.sndWnd;
    }

    @Override
    public void setSndWnd(int sndWnd) {
        this.sndWnd = sndWnd;
    }

    @Override
    public boolean isStream() {
        return this.stream;
    }

    @Override
    public void setStream(boolean stream) {
        this.stream = stream;
    }

    @Override
    public void setByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    @Override
    public KcpOutput getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(KcpOutput output) {
        this.output = output;
    }

    @Override
    public void setAckNoDelay(boolean ackNoDelay) {
        this.ackNoDelay = ackNoDelay;
    }

    @Override
    public int getSrtt() {
        return this.rxSrtt;
    }

    public String toString() {
        return "Kcp(conv=" + this.conv + ")";
    }

    public static class Segment {
        private final Recycler.Handle<Segment> recyclerHandle;
        private long conv;
        private byte cmd;
        private short frg;
        private int wnd;
        private long ts;
        private long sn;
        private long una;
        private long resendts;
        private int rto;
        private int fastack;
        private int xmit;
        private long ackMask;
        private ByteBuf data;
        private int ackMaskSize;
        private static final Recycler<Segment> RECYCLER = new Recycler<Segment>(){

            protected Segment newObject(Recycler.Handle<Segment> handle) {
                return new Segment(handle);
            }
        };

        private Segment(Recycler.Handle<Segment> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        void recycle(boolean releaseBuf) {
            this.conv = 0L;
            this.cmd = 0;
            this.frg = 0;
            this.wnd = 0;
            this.ts = 0L;
            this.sn = 0L;
            this.una = 0L;
            this.resendts = 0L;
            this.rto = 0;
            this.fastack = 0;
            this.xmit = 0;
            this.ackMask = 0L;
            if (releaseBuf && this.data != null) {
                this.data.release();
            }
            this.data = null;
            this.recyclerHandle.recycle((Object)this);
        }

        static Segment createSegment(ByteBufAllocator byteBufAllocator, int size) {
            Segment seg = (Segment)RECYCLER.get();
            seg.data = size == 0 ? null : byteBufAllocator.ioBuffer(size);
            return seg;
        }

        public static Segment createSegment(ByteBuf buf) {
            Segment seg = (Segment)RECYCLER.get();
            seg.data = buf;
            return seg;
        }

        public long getResendts() {
            return this.resendts;
        }

        public void setResendts(long resendts) {
            this.resendts = resendts;
        }

        public int getXmit() {
            return this.xmit;
        }

        public void setXmit(int xmit) {
            this.xmit = xmit;
        }
    }
}

