/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.order.waiteStrategy;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kcp.highway.threadPool.order.waiteStrategy.WaitCondition;
import kcp.highway.threadPool.order.waiteStrategy.WaitConditionStrategy;

public final class BlockingWaitConditionStrategy
implements WaitConditionStrategy {
    private final Lock lock;
    private final Condition processorNotifyCondition;

    public BlockingWaitConditionStrategy() {
        this(false);
    }

    public BlockingWaitConditionStrategy(boolean fairSync) {
        this.lock = new ReentrantLock(fairSync);
        this.processorNotifyCondition = this.lock.newCondition();
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitFor(WaitCondition<T> waitCondition, long timeOut, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long waitTime = unit.toNanos(timeOut);
            T task = waitCondition.getAttach();
            if (task == null) {
                this.processorNotifyCondition.awaitNanos(waitTime);
                task = waitCondition.getAttach();
            }
            T t = task;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

