/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Queue;
import kcp.highway.Ukcp;
import kcp.highway.erasure.fec.Snmp;
import kcp.highway.threadPool.ITask;

public class WriteTask
implements ITask {
    private final Ukcp ukcp;

    public WriteTask(Ukcp ukcp) {
        this.ukcp = ukcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Ukcp ukcp = this.ukcp;
        try {
            ByteBuf byteBuf;
            if (!ukcp.isActive()) {
                return;
            }
            Queue<ByteBuf> queue = ukcp.getWriteBuffer();
            int writeCount = 0;
            long writeBytes = 0L;
            while (ukcp.canSend(false) && (byteBuf = queue.poll()) != null) {
                ++writeCount;
                try {
                    writeBytes += (long)byteBuf.readableBytes();
                    ukcp.send(byteBuf);
                    byteBuf.release();
                }
                catch (IOException e) {
                    ukcp.getKcpListener().handleException(e, ukcp);
                    this.release();
                    return;
                }
            }
            Snmp.snmp.BytesSent.add(writeBytes);
            if (ukcp.isControlWriteBufferSize()) {
                ukcp.getWriteBufferIncr().addAndGet(writeCount);
            }
            if (!ukcp.canSend(false) || ukcp.checkFlush() && ukcp.isFastFlush()) {
                long now = System.currentTimeMillis();
                long next = ukcp.flush(now);
                ukcp.setTsUpdate(now + next);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.release();
        }
    }

    public void release() {
        this.ukcp.getWriteProcessing().set(false);
    }
}

