/*
 * Decompiled with CFR 0.152.
 */
package express;

import express.JavalinUtil;
import express.database.Database;
import express.http.HttpContextHandler;
import express.http.Request;
import express.http.Response;
import io.javalin.Javalin;
import io.javalin.core.JavalinConfig;
import io.javalin.http.Context;
import io.javalin.http.sse.SseClient;
import io.javalin.http.staticfiles.Location;
import io.javalin.websocket.WsHandler;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Express {
    private final Javalin app;
    private final Map<String, Object> locals = new ConcurrentHashMap<String, Object>();
    public static Logger log = LoggerFactory.getLogger(Express.class);

    public Express() {
        this(null);
    }

    public Express(Consumer<JavalinConfig> config) {
        JavalinUtil.disableJavalinLogger();
        this.app = config != null ? Javalin.create(config) : Javalin.create();
        this.app.config.showJavalinBanner = false;
        Runtime.getRuntime().addShutdownHook(new Thread(this.app::stop));
        this.app.events(event -> event.serverStartFailed(() -> log.error("Failed to start Express")));
    }

    public Javalin raw() {
        return this.app;
    }

    public Express useStatic(Path path) {
        this.useStatic(path.toString(), Location.EXTERNAL);
        return this;
    }

    public Express useStatic(String path, Location location) {
        this.app.config.addStaticFiles(path, location);
        return this;
    }

    public Express useStaticFallback(String url, Path filePath) {
        this.app.config.addSinglePageRoot(url, filePath.toString(), Location.EXTERNAL);
        return this;
    }

    public Express useStaticFallback(String url, String filePath, Location location) {
        this.app.config.addSinglePageRoot(url, filePath, location);
        return this;
    }

    public Express cors() {
        this.app.config.enableCorsForAllOrigins();
        return this;
    }

    public Express cors(String origin) {
        this.app.config.enableCorsForOrigin(origin);
        return this;
    }

    public Express devLogging() {
        this.app.config.enableDevLogging();
        return this;
    }

    public Express put(String path, HttpContextHandler handler) {
        this.app.put(path, (Context ctx) -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express get(String path, HttpContextHandler handler) {
        this.app.get(path, (Context ctx) -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express post(String path, HttpContextHandler handler) {
        this.app.post(path, (Context ctx) -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express patch(String path, HttpContextHandler handler) {
        this.app.patch(path, (Context ctx) -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express delete(String path, HttpContextHandler handler) {
        this.app.delete(path, (Context ctx) -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express use(HttpContextHandler handler) {
        this.app.before(ctx -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express use(String path, HttpContextHandler handler) {
        this.app.before(path, ctx -> handler.handle(new Request(ctx), new Response(ctx)));
        return this;
    }

    public Express all(String path, HttpContextHandler handler) {
        this.get(path, handler);
        this.post(path, handler);
        this.put(path, handler);
        this.patch(path, handler);
        this.delete(path, handler);
        return this;
    }

    public Express sse(String path, Consumer<SseClient> client) {
        this.app.sse(path, client);
        return this;
    }

    public Express ws(String path, Consumer<WsHandler> ws) {
        this.app.ws(path, ws);
        return this;
    }

    public List<Object> locals() {
        return (List)this.locals.values();
    }

    public <T> T locals(String name) {
        return (T)this.locals.get(name);
    }

    public Express locals(String name, Object obj) {
        this.locals.put(name, obj);
        return this;
    }

    public Express enable(String name) {
        this.locals.put(name, true);
        return this;
    }

    public Express disable(String name) {
        this.locals.put(name, false);
        return this;
    }

    public boolean enabled(String name) {
        return (Boolean)this.locals.get(name) == true;
    }

    public boolean disabled(String name) {
        return (Boolean)this.locals.get(name) == false;
    }

    public Express set(String name, Object obj) {
        this.locals.put(name, obj);
        return this;
    }

    public <T> T get(String name) {
        return (T)this.locals.get(name);
    }

    public void listen() {
        this.listen(80);
    }

    public void listen(int port) {
        if (nosqlite.Database.useWatchers || nosqlite.Database.useBrowser) {
            new Database(this);
        }
        this.app.start(port);
        JavalinUtil.reEnableJavalinLogger();
        Javalin.log.info("Server listening on http://localhost:" + port);
    }

    public void listen(String hostname, int port) {
        if (nosqlite.Database.useWatchers || nosqlite.Database.useBrowser) {
            new Database(this);
        }
        this.app.start(hostname, port);
        JavalinUtil.reEnableJavalinLogger();
        Javalin.log.info("Server listening on http://" + hostname + ":" + port);
    }

    public void stop() {
        JavalinUtil.disableJavalinLogger();
        this.app.stop();
        JavalinUtil.reEnableJavalinLogger();
        log.info("Express has stopped");
    }
}

