/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.highway.ChannelConfig;
import kcp.highway.FecOutPut;
import kcp.highway.IChannelManager;
import kcp.highway.IKcp;
import kcp.highway.Kcp;
import kcp.highway.KcpListener;
import kcp.highway.KcpOutput;
import kcp.highway.ReadTask;
import kcp.highway.User;
import kcp.highway.WriteTask;
import kcp.highway.erasure.FecAdapt;
import kcp.highway.erasure.IFecDecode;
import kcp.highway.erasure.IFecEncode;
import kcp.highway.erasure.fec.Fec;
import kcp.highway.erasure.fec.FecPacket;
import kcp.highway.erasure.fec.Snmp;
import kcp.highway.threadPool.IMessageExecutor;
import org.jctools.queues.MpscLinkedQueue;

public class Ukcp {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Ukcp.class);
    private final IKcp kcp;
    private boolean fastFlush = true;
    private long tsUpdate = -1L;
    private boolean active;
    private IFecEncode fecEncode = null;
    private IFecDecode fecDecode = null;
    private final Queue<ByteBuf> writeBuffer;
    private final Queue<ByteBuf> readBuffer;
    private final IMessageExecutor iMessageExecutor;
    private final KcpListener kcpListener;
    private final long timeoutMillis;
    private final IChannelManager channelManager;
    private final AtomicBoolean writeProcessing = new AtomicBoolean(false);
    private final AtomicBoolean readProcessing = new AtomicBoolean(false);
    private final AtomicInteger readBufferIncr = new AtomicInteger(-1);
    private final AtomicInteger writeBufferIncr = new AtomicInteger(-1);
    private final WriteTask writeTask = new WriteTask(this);
    private final ReadTask readTask = new ReadTask(this);
    private boolean controlReadBufferSize = false;
    private boolean controlWriteBufferSize = false;
    private long lastRecieveTime = System.currentTimeMillis();

    public Ukcp(KcpOutput output, KcpListener kcpListener, IMessageExecutor iMessageExecutor, ChannelConfig channelConfig, IChannelManager channelManager) {
        this.timeoutMillis = channelConfig.getTimeoutMillis();
        this.kcp = new Kcp(channelConfig.getConv(), output);
        this.active = true;
        this.kcpListener = kcpListener;
        this.iMessageExecutor = iMessageExecutor;
        this.channelManager = channelManager;
        this.writeBuffer = new MpscLinkedQueue<ByteBuf>();
        this.readBuffer = new MpscLinkedQueue<ByteBuf>();
        if (channelConfig.getReadBufferSize() != -1) {
            this.controlReadBufferSize = true;
            this.readBufferIncr.set(channelConfig.getReadBufferSize() / channelConfig.getMtu());
        }
        if (channelConfig.getWriteBufferSize() != -1) {
            this.controlWriteBufferSize = true;
            this.writeBufferIncr.set(channelConfig.getWriteBufferSize() / channelConfig.getMtu());
        }
        int headerSize = 0;
        FecAdapt fecAdapt = channelConfig.getFecAdapt();
        if (channelConfig.isCrc32Check()) {
            headerSize += 4;
        }
        if (fecAdapt != null) {
            KcpOutput kcpOutput = this.kcp.getOutput();
            this.fecEncode = fecAdapt.fecEncode(headerSize, channelConfig.getMtu());
            this.fecDecode = fecAdapt.fecDecode(channelConfig.getMtu());
            kcpOutput = new FecOutPut(kcpOutput, this.fecEncode);
            this.kcp.setOutput(kcpOutput);
            headerSize += Fec.fecHeaderSizePlus2;
        }
        this.kcp.setReserved(headerSize);
        this.initKcpConfig(channelConfig);
    }

    private void initKcpConfig(ChannelConfig channelConfig) {
        this.kcp.nodelay(channelConfig.isNodelay(), channelConfig.getInterval(), channelConfig.getFastresend(), channelConfig.isNocwnd());
        this.kcp.setSndWnd(channelConfig.getSndwnd());
        this.kcp.setRcvWnd(channelConfig.getRcvwnd());
        this.kcp.setMtu(channelConfig.getMtu());
        this.kcp.setStream(channelConfig.isStream());
        this.kcp.setAckNoDelay(channelConfig.isAckNoDelay());
        this.kcp.setAckMaskSize(channelConfig.getAckMaskSize());
        this.fastFlush = channelConfig.isFastFlush();
    }

    public void sendDisconnectPacket(int code) {
        long conv = this.getConv();
        ByteBuf packet = Unpooled.buffer((int)20);
        packet.writeInt(404);
        packet.writeIntLE((int)(conv >> 32));
        packet.writeIntLE((int)(conv & 0xFFFFFFFFL));
        packet.writeInt(code);
        packet.writeInt(0x19419494);
        this.UDPSend(packet);
    }

    public static void sendHandshakeRsp(User user, int enet, long conv) {
        ByteBuf packet = Unpooled.buffer((int)20);
        packet.writeInt(325);
        packet.writeIntLE((int)(conv >> 32));
        packet.writeIntLE((int)(conv & 0xFFFFFFFFL));
        packet.writeInt(enet);
        packet.writeInt(0x14514545);
        Ukcp.UDPSend(packet, user);
    }

    public void UDPSend(ByteBuf packet) {
        User user = this.kcp.getUser();
        Ukcp.UDPSend(packet, user);
    }

    public static void UDPSend(ByteBuf packet, User user) {
        DatagramPacket datagramPacket = new DatagramPacket(packet, user.getRemoteAddress(), user.getLocalAddress());
        user.getChannel().writeAndFlush((Object)datagramPacket);
    }

    protected void receive(List<ByteBuf> bufList) {
        this.kcp.recv(bufList);
    }

    protected ByteBuf mergeReceive() {
        return this.kcp.mergeRecv();
    }

    protected void input(ByteBuf data, long current) throws IOException {
        Snmp.snmp.InPkts.increment();
        Snmp.snmp.InBytes.add(data.readableBytes());
        if (this.fecDecode != null) {
            List<ByteBuf> byteBufs;
            FecPacket fecPacket = FecPacket.newFecPacket(data);
            if (fecPacket.getFlag() == Fec.typeData) {
                data.skipBytes(2);
                this.input(data, true, current);
            }
            if ((fecPacket.getFlag() == Fec.typeData || fecPacket.getFlag() == Fec.typeParity) && (byteBufs = this.fecDecode.decode(fecPacket)) != null) {
                for (int i = 0; i < byteBufs.size(); ++i) {
                    ByteBuf byteBuf = byteBufs.get(i);
                    this.input(byteBuf, false, current);
                    byteBuf.release();
                }
            }
        } else {
            this.input(data, true, current);
        }
    }

    private void input(ByteBuf data, boolean regular, long current) throws IOException {
        int ret = this.kcp.input(data, regular, current);
        switch (ret) {
            case -1: {
                throw new IOException("No enough bytes of head");
            }
            case -2: {
                throw new IOException("No enough bytes of data");
            }
            case -3: {
                throw new IOException("Mismatch cmd");
            }
            case -4: {
                throw new IOException("Conv inconsistency");
            }
        }
    }

    void send(ByteBuf buf) throws IOException {
        int ret = this.kcp.send(buf);
        if (ret == -2) {
            throw new IOException("Too many fragments");
        }
    }

    protected boolean canRecv() {
        return this.kcp.canRecv();
    }

    protected long getLastRecieveTime() {
        return this.lastRecieveTime;
    }

    protected void setLastRecieveTime(long lastRecieveTime) {
        this.lastRecieveTime = lastRecieveTime;
    }

    protected boolean canSend(boolean curCanSend) {
        int max = this.kcp.getSndWnd() * 2;
        int waitSnd = this.kcp.waitSnd();
        if (curCanSend) {
            return waitSnd < max;
        }
        int threshold = Math.max(1, max / 2);
        return waitSnd < threshold;
    }

    protected long update(long current) {
        this.kcp.update(current);
        long nextTsUp = this.check(current);
        this.setTsUpdate(nextTsUp);
        return nextTsUp;
    }

    protected long flush(long current) {
        return this.kcp.flush(false, current);
    }

    protected long check(long current) {
        return this.kcp.check(current);
    }

    protected boolean checkFlush() {
        return this.kcp.checkFlush();
    }

    public long getConv() {
        return this.kcp.getConv();
    }

    public void setConv(long conv) {
        this.kcp.setConv(conv);
    }

    protected int getInterval() {
        return this.kcp.getInterval();
    }

    protected boolean isStream() {
        return this.kcp.isStream();
    }

    public Ukcp setByteBufAllocator(ByteBufAllocator allocator) {
        this.kcp.setByteBufAllocator(allocator);
        return this;
    }

    protected boolean isFastFlush() {
        return this.fastFlush;
    }

    protected void read(ByteBuf byteBuf) {
        int readBufferSize;
        if (this.controlReadBufferSize && (readBufferSize = this.readBufferIncr.getAndUpdate(operand -> {
            if (operand == 0) {
                return operand;
            }
            return --operand;
        })) == 0) {
            ByteBuf pack = this.readBuffer.poll();
            if (pack != null) {
                pack.release();
            }
            return;
        }
        this.readBuffer.offer(byteBuf);
        this.notifyReadEvent();
    }

    public boolean write(ByteBuf byteBuf) {
        int bufferSize;
        if (this.controlWriteBufferSize && (bufferSize = this.writeBufferIncr.getAndUpdate(operand -> {
            if (operand == 0) {
                return operand;
            }
            return --operand;
        })) == 0) {
            return false;
        }
        byteBuf = byteBuf.retainedDuplicate();
        this.writeBuffer.offer(byteBuf);
        this.notifyWriteEvent();
        return true;
    }

    protected AtomicInteger getReadBufferIncr() {
        return this.readBufferIncr;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean sendDisconnectPack) {
        if (sendDisconnectPack) {
            this.sendDisconnectPacket(5);
        }
        this.iMessageExecutor.execute(() -> this.internalClose());
    }

    private void notifyReadEvent() {
        if (this.readProcessing.compareAndSet(false, true)) {
            this.iMessageExecutor.execute(this.readTask);
        }
    }

    protected void notifyWriteEvent() {
        if (this.writeProcessing.compareAndSet(false, true)) {
            this.iMessageExecutor.execute(this.writeTask);
        }
    }

    protected long getTsUpdate() {
        return this.tsUpdate;
    }

    protected Queue<ByteBuf> getReadBuffer() {
        return this.readBuffer;
    }

    protected Ukcp setTsUpdate(long tsUpdate) {
        this.tsUpdate = tsUpdate;
        return this;
    }

    protected Queue<ByteBuf> getWriteBuffer() {
        return this.writeBuffer;
    }

    protected KcpListener getKcpListener() {
        return this.kcpListener;
    }

    public boolean isActive() {
        return this.active;
    }

    void internalClose() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.notifyReadEvent();
        this.kcpListener.handleClose(this);
        this.notifyWriteEvent();
        this.kcp.flush(false, System.currentTimeMillis());
        this.channelManager.del(this);
        this.release();
    }

    void release() {
        ByteBuf byteBuf;
        this.kcp.setState(-1);
        this.kcp.release();
        while ((byteBuf = this.writeBuffer.poll()) != null) {
            byteBuf.release();
        }
        while ((byteBuf = this.readBuffer.poll()) != null) {
            byteBuf.release();
        }
        if (this.fecEncode != null) {
            this.fecEncode.release();
        }
        if (this.fecDecode != null) {
            this.fecDecode.release();
        }
    }

    protected AtomicBoolean getWriteProcessing() {
        return this.writeProcessing;
    }

    protected AtomicBoolean getReadProcessing() {
        return this.readProcessing;
    }

    protected IMessageExecutor getiMessageExecutor() {
        return this.iMessageExecutor;
    }

    protected long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    protected AtomicInteger getWriteBufferIncr() {
        return this.writeBufferIncr;
    }

    protected boolean isControlReadBufferSize() {
        return this.controlReadBufferSize;
    }

    protected boolean isControlWriteBufferSize() {
        return this.controlWriteBufferSize;
    }

    public User user() {
        return this.kcp.getUser();
    }

    public int srtt() {
        return this.kcp.getSrtt();
    }

    protected Ukcp user(User user) {
        this.kcp.setUser(user);
        return this;
    }

    public String toString() {
        return "Ukcp(getConv=" + this.kcp.getConv() + ", state=" + this.kcp.getState() + ", active=" + this.active + ")";
    }
}

