/*
 * Decompiled with CFR 0.152.
 */
package nosqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nosqlite.Collection;
import nosqlite.DbHelper;
import nosqlite.annotations.Document;
import nosqlite.handlers.CollectionConfig;
import nosqlite.handlers.CollectionConfigHandler;
import org.reflections8.Reflections;

public class Database {
    private static Map<String, Collection> collections = new ConcurrentHashMap<String, Collection>();
    private static Connection conn;
    private static DbHelper dbHelper;
    private static Database singleton;
    public static boolean runAsync;
    public static boolean useBrowser;
    public static boolean useWatchers;
    public static boolean runTestSuite;
    public static String dbPath;

    private Database() {
        this.initDatabase();
    }

    private void initDatabase() {
        File dir;
        if (!dbPath.equals(":memory:") && (dir = new File(dbPath = dbPath.replaceAll("^/", ""))).getParentFile() != null) {
            dir.getParentFile().mkdirs();
        }
        try {
            conn = DriverManager.getConnection("jdbc:sqlite:" + dbPath);
            dbHelper = new DbHelper(conn, true, runAsync);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return;
        }
        Set<Class<?>> klasses = new Reflections(new Object[0]).getTypesAnnotatedWith(Document.class);
        for (Class<?> k : klasses) {
            if (!runTestSuite && k.getPackage().getName().contains("test_entities")) continue;
            String name = k.getAnnotation(Document.class).collection();
            name = name.equals("default_coll") ? k.getSimpleName() : name;
            collections.putIfAbsent(name, new Collection(dbHelper, k, name));
        }
    }

    public static List<String> collectionNames() {
        String tablesQuery = dbHelper.get("SELECT GROUP_CONCAT(name) FROM sqlite_master WHERE type='table'");
        String[] tables = tablesQuery.split(",");
        ArrayList<String> asList2 = new ArrayList<String>();
        for (String table : tables) {
            int count = Integer.parseInt(dbHelper.get(String.format("SELECT COUNT(*) FROM %s", table)));
            if (count <= 0) continue;
            asList2.add(table);
        }
        return asList2;
    }

    public static Collection collection(Class klass) {
        return Database.collection(klass.getSimpleName());
    }

    public static Collection collection() {
        return Database.collection("default_coll");
    }

    public static Collection collection(String doc) {
        Collection coll;
        if (singleton == null) {
            singleton = new Database();
        }
        if ((coll = collections.get(doc)) == null) {
            coll = new Collection(dbHelper, null, doc);
            collections.put(doc, coll);
        }
        return coll;
    }

    public static void collection(CollectionConfigHandler config) {
        CollectionConfig op = new CollectionConfig();
        config.handle(op);
        Database.collection(op);
    }

    public static void collection(CollectionConfig config) {
        if (singleton == null) {
            runAsync = config.runAsync;
            dbPath = config.dbPath;
            useBrowser = config.useBrowser;
            useWatchers = config.useWatcher;
            runTestSuite = config.runTestSuite;
            singleton = new Database();
        } else {
            System.err.println("collection with config must be called before any other collection call");
        }
    }

    static {
        dbHelper = null;
        singleton = null;
        runAsync = true;
        useBrowser = false;
        useWatchers = false;
        runTestSuite = false;
        dbPath = "db/data.db";
    }
}

