/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.Consts;
import io.jpower.kcp.netty.Ukcp;
import io.jpower.kcp.netty.UkcpChannelConfig;
import io.jpower.kcp.netty.UkcpChannelOption;
import io.jpower.kcp.netty.UkcpClientChannel;
import io.jpower.kcp.netty.UkcpClientChannelConfig;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Map;
import java.util.Objects;

public class DefaultUkcpClientChannelConfig
extends DefaultChannelConfig
implements UkcpClientChannelConfig {
    private final Ukcp ukcp;
    private final DatagramSocket javaSocket;

    public DefaultUkcpClientChannelConfig(UkcpClientChannel channel, Ukcp ukcp, DatagramSocket javaSocket) {
        super((Channel)channel, (RecvByteBufAllocator)new FixedRecvByteBufAllocator(Consts.FIXED_RECV_BYTEBUF_ALLOCATE_SIZE));
        this.ukcp = Objects.requireNonNull(ukcp, "ukcp");
        this.javaSocket = Objects.requireNonNull(javaSocket, "javaSocket");
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{UkcpChannelOption.UKCP_NODELAY, UkcpChannelOption.UKCP_INTERVAL, UkcpChannelOption.UKCP_FAST_RESEND, UkcpChannelOption.UKCP_FAST_LIMIT, UkcpChannelOption.UKCP_NOCWND, UkcpChannelOption.UKCP_MIN_RTO, UkcpChannelOption.UKCP_MTU, UkcpChannelOption.UKCP_RCV_WND, UkcpChannelOption.UKCP_SND_WND, UkcpChannelOption.UKCP_STREAM, UkcpChannelOption.UKCP_DEAD_LINK, UkcpChannelOption.UKCP_AUTO_SET_CONV, UkcpChannelOption.UKCP_FAST_FLUSH, UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF, UkcpChannelOption.SO_RCVBUF, UkcpChannelOption.SO_SNDBUF, UkcpChannelOption.SO_REUSEADDR, UkcpChannelOption.IP_TOS});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == UkcpChannelOption.UKCP_NODELAY) {
            return (T)Boolean.valueOf(this.isNodelay());
        }
        if (option == UkcpChannelOption.UKCP_INTERVAL) {
            return (T)Integer.valueOf(this.getInterval());
        }
        if (option == UkcpChannelOption.UKCP_FAST_RESEND) {
            return (T)Integer.valueOf(this.getFastResend());
        }
        if (option == UkcpChannelOption.UKCP_FAST_LIMIT) {
            return (T)Integer.valueOf(this.getFastLimit());
        }
        if (option == UkcpChannelOption.UKCP_NOCWND) {
            return (T)Boolean.valueOf(this.isNocwnd());
        }
        if (option == UkcpChannelOption.UKCP_MIN_RTO) {
            return (T)Integer.valueOf(this.getMinRto());
        }
        if (option == UkcpChannelOption.UKCP_MTU) {
            return (T)Integer.valueOf(this.getMtu());
        }
        if (option == UkcpChannelOption.UKCP_RCV_WND) {
            return (T)Integer.valueOf(this.getRcvWnd());
        }
        if (option == UkcpChannelOption.UKCP_SND_WND) {
            return (T)Integer.valueOf(this.getSndWnd());
        }
        if (option == UkcpChannelOption.UKCP_STREAM) {
            return (T)Boolean.valueOf(this.isStream());
        }
        if (option == UkcpChannelOption.UKCP_DEAD_LINK) {
            return (T)Integer.valueOf(this.getDeadLink());
        }
        if (option == UkcpChannelOption.UKCP_AUTO_SET_CONV) {
            return (T)Boolean.valueOf(this.isAutoSetConv());
        }
        if (option == UkcpChannelOption.UKCP_FAST_FLUSH) {
            return (T)Boolean.valueOf(this.isFastFlush());
        }
        if (option == UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF) {
            return (T)Boolean.valueOf(this.isMergeSegmentBuf());
        }
        if (option == UkcpChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getUdpReceiveBufferSize());
        }
        if (option == UkcpChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getUdpSendBufferSize());
        }
        if (option == UkcpChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == UkcpChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getUdpTrafficClass());
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == UkcpChannelOption.UKCP_NODELAY) {
            this.setNodelay((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_INTERVAL) {
            this.setInterval((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_RESEND) {
            this.setFastResend((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_LIMIT) {
            this.setFastLimit((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_NOCWND) {
            this.setNocwnd((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_MIN_RTO) {
            this.setMinRto((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_MTU) {
            this.setMtu((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_RCV_WND) {
            this.setRcvWnd((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_SND_WND) {
            this.setSndWnd((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_STREAM) {
            this.setStream((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_DEAD_LINK) {
            this.setDeadLink((Integer)value);
        } else if (option == UkcpChannelOption.UKCP_AUTO_SET_CONV) {
            this.setAutoSetConv((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_FAST_FLUSH) {
            this.setFastFlush((Boolean)value);
        } else if (option == UkcpChannelOption.UKCP_MERGE_SEGMENT_BUF) {
            this.setMergeSegmentBuf((Boolean)value);
        } else if (option == UkcpChannelOption.SO_RCVBUF) {
            this.setUdpReceiveBufferSize((Integer)value);
        } else if (option == UkcpChannelOption.SO_SNDBUF) {
            this.setUdpSendBufferSize((Integer)value);
        } else if (option == UkcpChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == UkcpChannelOption.IP_TOS) {
            this.setUdpTrafficClass((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    @Override
    public boolean isNodelay() {
        return this.ukcp.isNodelay();
    }

    @Override
    public UkcpClientChannelConfig setNodelay(boolean nodelay) {
        this.ukcp.setNodelay(nodelay);
        return this;
    }

    @Override
    public int getInterval() {
        return this.ukcp.getInterval();
    }

    @Override
    public UkcpClientChannelConfig setInterval(int interval) {
        this.ukcp.setInterval(interval);
        return this;
    }

    @Override
    public int getFastResend() {
        return this.ukcp.getFastResend();
    }

    @Override
    public UkcpClientChannelConfig setFastResend(int fastResend) {
        this.ukcp.setFastResend(fastResend);
        return this;
    }

    @Override
    public int getFastLimit() {
        return this.ukcp.getFastLimit();
    }

    @Override
    public UkcpChannelConfig setFastLimit(int fastLimit) {
        this.ukcp.setFastLimit(fastLimit);
        return this;
    }

    @Override
    public boolean isNocwnd() {
        return this.ukcp.isNocwnd();
    }

    @Override
    public UkcpClientChannelConfig setNocwnd(boolean nocwnd) {
        this.ukcp.setNocwnd(nocwnd);
        return this;
    }

    @Override
    public int getMinRto() {
        return this.ukcp.getMinRto();
    }

    @Override
    public UkcpClientChannelConfig setMinRto(int minRto) {
        this.ukcp.setMinRto(minRto);
        return this;
    }

    @Override
    public int getMtu() {
        return this.ukcp.getMtu();
    }

    @Override
    public UkcpClientChannelConfig setMtu(int mtu) {
        this.ukcp.setMtu(mtu);
        return this;
    }

    @Override
    public int getRcvWnd() {
        return this.ukcp.getRcvWnd();
    }

    @Override
    public UkcpClientChannelConfig setRcvWnd(int rcvWnd) {
        this.ukcp.setRcvWnd(rcvWnd);
        return this;
    }

    @Override
    public int getSndWnd() {
        return this.ukcp.getSndWnd();
    }

    @Override
    public UkcpClientChannelConfig setSndWnd(int sndWnd) {
        this.ukcp.setSndWnd(sndWnd);
        return this;
    }

    @Override
    public boolean isStream() {
        return this.ukcp.isStream();
    }

    @Override
    public UkcpClientChannelConfig setStream(boolean stream) {
        this.ukcp.setStream(stream);
        return this;
    }

    @Override
    public int getDeadLink() {
        return this.ukcp.getDeadLink();
    }

    @Override
    public UkcpClientChannelConfig setDeadLink(int deadLink) {
        this.ukcp.setDeadLink(deadLink);
        return this;
    }

    @Override
    public boolean isAutoSetConv() {
        return this.ukcp.isAutoSetConv();
    }

    @Override
    public UkcpChannelConfig setAutoSetConv(boolean autoSetConv) {
        this.ukcp.setAutoSetConv(autoSetConv);
        return this;
    }

    @Override
    public boolean isFastFlush() {
        return this.ukcp.isFastFlush();
    }

    @Override
    public UkcpChannelConfig setFastFlush(boolean fastFlush) {
        this.ukcp.setFastFlush(fastFlush);
        return this;
    }

    @Override
    public boolean isMergeSegmentBuf() {
        return this.ukcp.isMergeSegmentBuf();
    }

    @Override
    public UkcpChannelConfig setMergeSegmentBuf(boolean mergeSegmentBuf) {
        this.ukcp.setMergeSegmentBuf(mergeSegmentBuf);
        return this;
    }

    @Override
    public int getUdpReceiveBufferSize() {
        try {
            return this.javaSocket.getReceiveBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Override
    public UkcpClientChannelConfig setUdpReceiveBufferSize(int receiveBufferSize) {
        try {
            this.javaSocket.setReceiveBufferSize(receiveBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
        return this;
    }

    @Override
    public int getUdpSendBufferSize() {
        try {
            return this.javaSocket.getSendBufferSize();
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Override
    public UkcpClientChannelConfig setUdpSendBufferSize(int sendBufferSize) {
        try {
            this.javaSocket.setSendBufferSize(sendBufferSize);
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
        return this;
    }

    @Override
    public int getUdpTrafficClass() {
        try {
            return this.javaSocket.getTrafficClass();
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Override
    public UkcpClientChannelConfig setUdpTrafficClass(int trafficClass) {
        try {
            this.javaSocket.setTrafficClass(trafficClass);
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
        return this;
    }

    @Override
    public boolean isReuseAddress() {
        try {
            return this.javaSocket.getReuseAddress();
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    @Override
    public UkcpClientChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            this.javaSocket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            throw new ChannelException((Throwable)e);
        }
        return this;
    }

    @Override
    public UkcpClientChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        this.ukcp.setByteBufAllocator(allocator);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    @Deprecated
    public UkcpClientChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setAutoClose(boolean autoClose) {
        super.setAutoClose(autoClose);
        return this;
    }

    public UkcpClientChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    public UkcpClientChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public UkcpClientChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }
}

