/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.order.waiteStrategy;

import java.util.concurrent.TimeUnit;
import kcp.highway.threadPool.order.waiteStrategy.WaitCondition;
import kcp.highway.threadPool.order.waiteStrategy.WaitConditionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YieldingWaitConditionStrategy
implements WaitConditionStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int SPIN_TRIES = 1000;

    @Override
    public <T> T waitFor(WaitCondition<T> waitCondition, long timeOut, TimeUnit unit) {
        T task;
        long endTime = System.nanoTime() + unit.toNanos(timeOut);
        int counter = 1000;
        while ((task = waitCondition.getAttach()) == null && System.nanoTime() < endTime) {
            counter = this.applyWaitMethod(counter);
        }
        return task;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(int counter) {
        if (0 == counter) {
            Thread.yield();
        } else {
            --counter;
        }
        return counter;
    }
}

