/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty.internal;

import io.netty.util.Recycler;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

public class CodecOutputList<T>
extends AbstractList<T>
implements RandomAccess {
    private static final Recycler<CodecOutputList> RECYCLER = new Recycler<CodecOutputList>(){

        protected CodecOutputList newObject(Recycler.Handle<CodecOutputList> handle) {
            return new CodecOutputList(handle, null);
        }
    };
    private final Recycler.Handle<CodecOutputList<T>> handle;
    private int size;
    private Object[] array = new Object[16];
    private boolean insertSinceRecycled;

    public static <T> CodecOutputList<T> newInstance() {
        return (CodecOutputList)RECYCLER.get();
    }

    private CodecOutputList(Recycler.Handle<CodecOutputList<T>> handle) {
        this.handle = handle;
    }

    @Override
    public T get(int index) {
        this.checkIndex(index);
        return (T)this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object element) {
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        int newSize = this.size + 1;
        if (newSize > this.array.length) {
            this.expandArray();
        }
        this.insert(this.size, element);
        this.size = newSize;
        return true;
    }

    @Override
    public T set(int index, Object element) {
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        this.checkIndex(index);
        Object old = this.array[index];
        this.insert(index, element);
        return (T)old;
    }

    @Override
    public void add(int index, Object element) {
        ObjectUtil.checkNotNull((Object)element, (String)"element");
        this.checkIndex(index);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (index != this.size - 1) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.insert(index, element);
        ++this.size;
    }

    @Override
    public T remove(int index) {
        this.checkIndex(index);
        Object old = this.array[index];
        int len = this.size - index - 1;
        if (len > 0) {
            System.arraycopy(this.array, index + 1, this.array, index, len);
        }
        this.array[--this.size] = null;
        return (T)old;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public void recycle() {
        int i = 0;
        while (i < this.size) {
            this.array[i] = null;
            ++i;
        }
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle((Object)this);
    }

    public T getUnsafe(int index) {
        return (T)this.array[index];
    }

    private void checkIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void insert(int index, Object element) {
        this.array[index] = element;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int newCapacity = this.array.length << 1;
        if (newCapacity < 0) {
            throw new OutOfMemoryError();
        }
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
    }

    /* synthetic */ CodecOutputList(Recycler.Handle handle, CodecOutputList codecOutputList) {
        this(handle);
    }
}

