/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.netty;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.IMessageExecutorPool;
import kcp.highway.threadPool.netty.NettyMessageExecutor;

public class NettyMessageExecutorPool
implements IMessageExecutorPool {
    private EventLoopGroup eventExecutors;
    protected static final AtomicInteger index = new AtomicInteger();

    public NettyMessageExecutorPool(int workSize) {
        this.eventExecutors = new DefaultEventLoopGroup(workSize, r -> new Thread(r, "nettyMessageExecutorPool-" + index.incrementAndGet()));
    }

    @Override
    public IMessageExecutor getIMessageExecutor() {
        return new NettyMessageExecutor(this.eventExecutors.next());
    }

    @Override
    public void stop() {
        if (!this.eventExecutors.isShuttingDown()) {
            this.eventExecutors.shutdownGracefully();
        }
    }
}

