/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.erasure;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import kcp.highway.erasure.IFecDecode;
import kcp.highway.erasure.IFecEncode;
import kcp.highway.erasure.ReedSolomon;
import kcp.highway.erasure.fec.FecDecode;
import kcp.highway.erasure.fec.FecEncode;
import kcp.highway.erasure.fecNative.ReedSolomonNative;

public class FecAdapt {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(FecAdapt.class);
    private ReedSolomonNative reedSolomonNative;
    private ReedSolomon reedSolomon;

    public FecAdapt(int dataShards, int parityShards) {
        if (ReedSolomonNative.isNativeSupport()) {
            this.reedSolomonNative = new ReedSolomonNative(dataShards, parityShards);
            log.info("fec use C native reedSolomon dataShards {} parityShards {}", (Object)dataShards, (Object)parityShards);
        } else {
            this.reedSolomon = ReedSolomon.create(dataShards, parityShards);
            log.info("fec use jvm reedSolomon dataShards {} parityShards {}", (Object)dataShards, (Object)parityShards);
        }
    }

    public IFecEncode fecEncode(int headerOffset, int mtu) {
        IFecEncode iFecEncode = this.reedSolomonNative != null ? new kcp.highway.erasure.fecNative.FecEncode(headerOffset, this.reedSolomonNative, mtu) : new FecEncode(headerOffset, this.reedSolomon, mtu);
        return iFecEncode;
    }

    public IFecDecode fecDecode(int mtu) {
        IFecDecode iFecDecode = this.reedSolomonNative != null ? new kcp.highway.erasure.fecNative.FecDecode(3 * this.reedSolomonNative.getTotalShardCount(), this.reedSolomonNative, mtu) : new FecDecode(3 * this.reedSolomon.getTotalShardCount(), this.reedSolomon, mtu);
        return iFecDecode;
    }
}

