/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.maps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jctools.maps.AbstractEntry;
import org.jctools.maps.ConcurrentAutoTable;
import org.jctools.util.RangeUtil;
import org.jctools.util.UnsafeAccess;

public class NonBlockingHashMap<TypeK, TypeV>
extends AbstractMap<TypeK, TypeV>
implements ConcurrentMap<TypeK, TypeV>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final int REPROBE_LIMIT = 10;
    private static final int _Obase = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    private static final int _Oscale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
    private static final int _Olog = _Oscale == 4 ? 2 : (_Oscale == 8 ? 3 : 9999);
    private static final long _kvs_offset = UnsafeAccess.fieldOffset(NonBlockingHashMap.class, "_kvs");
    private transient Object[] _kvs;
    private transient long _last_resize_milli;
    private static final int MIN_SIZE_LOG = 3;
    private static final int MIN_SIZE = 8;
    private static final Object NO_MATCH_OLD = new Object();
    private static final Object MATCH_ANY = new Object();
    public static final Object TOMBSTONE = new Object();
    private static final Prime TOMBPRIME = new Prime(TOMBSTONE);
    private transient ConcurrentAutoTable _reprobes = new ConcurrentAutoTable();
    static volatile int DUMMY_VOLATILE;

    private static long rawIndex(Object[] ary, int idx) {
        assert (idx >= 0 && idx < ary.length);
        return (long)_Obase + ((long)idx << _Olog);
    }

    private final boolean CAS_kvs(Object[] oldkvs, Object[] newkvs) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _kvs_offset, oldkvs, newkvs);
    }

    private static final int hash(Object key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        h += h << 7;
        return h;
    }

    private static final CHM chm(Object[] kvs) {
        return (CHM)kvs[0];
    }

    private static final int[] hashes(Object[] kvs) {
        return (int[])kvs[1];
    }

    private static final int len(Object[] kvs) {
        return kvs.length - 2 >> 1;
    }

    private static final Object key(Object[] kvs, int idx) {
        return kvs[(idx << 1) + 2];
    }

    private static final Object val(Object[] kvs, int idx) {
        return kvs[(idx << 1) + 3];
    }

    private static final boolean CAS_key(Object[] kvs, int idx, Object old, Object key) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(kvs, NonBlockingHashMap.rawIndex(kvs, (idx << 1) + 2), old, key);
    }

    private static final boolean CAS_val(Object[] kvs, int idx, Object old, Object val) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(kvs, NonBlockingHashMap.rawIndex(kvs, (idx << 1) + 3), old, val);
    }

    public final void print() {
        System.out.println("=========");
        this.print2(this._kvs);
        System.out.println("=========");
    }

    private final void print(Object[] kvs) {
        for (int i = 0; i < NonBlockingHashMap.len(kvs); ++i) {
            Object K = NonBlockingHashMap.key(kvs, i);
            if (K == null) continue;
            String KS = K == TOMBSTONE ? "XXX" : K.toString();
            Object V = NonBlockingHashMap.val(kvs, i);
            Object U = Prime.unbox(V);
            String p = V == U ? "" : "prime_";
            String US = U == TOMBSTONE ? "tombstone" : U.toString();
            System.out.println(i + " (" + KS + "," + p + US + ")");
        }
        Object[] newkvs = NonBlockingHashMap.chm((Object[])kvs)._newkvs;
        if (newkvs != null) {
            System.out.println("----");
            this.print(newkvs);
        }
    }

    private final void print2(Object[] kvs) {
        for (int i = 0; i < NonBlockingHashMap.len(kvs); ++i) {
            Object key = NonBlockingHashMap.key(kvs, i);
            Object val = NonBlockingHashMap.val(kvs, i);
            Object U = Prime.unbox(val);
            if (key == null || key == TOMBSTONE || val == null || U == TOMBSTONE) continue;
            String p = val == U ? "" : "prime_";
            System.out.println(i + " (" + key + "," + p + val + ")");
        }
        Object[] newkvs = NonBlockingHashMap.chm((Object[])kvs)._newkvs;
        if (newkvs != null) {
            System.out.println("----");
            this.print2(newkvs);
        }
    }

    public long reprobes() {
        long r = this._reprobes.get();
        this._reprobes = new ConcurrentAutoTable();
        return r;
    }

    private static int reprobe_limit(int len) {
        return 10 + (len >> 4);
    }

    public NonBlockingHashMap() {
        this(8);
    }

    public NonBlockingHashMap(int initial_sz) {
        this.initialize(initial_sz);
    }

    private final void initialize(int initial_sz) {
        RangeUtil.checkPositiveOrZero(initial_sz, "initial_sz");
        if (initial_sz > 0x100000) {
            initial_sz = 0x100000;
        }
        int i = 3;
        while (1 << i < initial_sz << 2) {
            ++i;
        }
        this._kvs = new Object[(1 << i << 1) + 2];
        this._kvs[0] = new CHM(new ConcurrentAutoTable());
        this._kvs[1] = new int[1 << i];
        this._last_resize_milli = System.currentTimeMillis();
    }

    protected final void initialize() {
        this.initialize(8);
    }

    @Override
    public int size() {
        return NonBlockingHashMap.chm(this._kvs).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean contains(Object val) {
        return this.containsValue(val);
    }

    @Override
    public TypeV put(TypeK key, TypeV val) {
        return this.putIfMatch(key, val, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(TypeK key, TypeV val) {
        return this.putIfMatch(key, val, TOMBSTONE);
    }

    @Override
    public TypeV remove(Object key) {
        return this.putIfMatch(key, TOMBSTONE, NO_MATCH_OLD);
    }

    @Override
    public boolean remove(Object key, Object val) {
        return NonBlockingHashMap.objectsEquals(this.putIfMatch(key, TOMBSTONE, val), val);
    }

    @Override
    public TypeV replace(TypeK key, TypeV val) {
        return this.putIfMatch(key, val, MATCH_ANY);
    }

    @Override
    public boolean replace(TypeK key, TypeV oldValue, TypeV newValue) {
        return NonBlockingHashMap.objectsEquals(this.putIfMatch(key, newValue, oldValue), oldValue);
    }

    private static boolean objectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public final TypeV putIfMatchAllowNull(Object key, Object newVal, Object oldVal) {
        if (oldVal == null) {
            oldVal = TOMBSTONE;
        }
        if (newVal == null) {
            newVal = TOMBSTONE;
        }
        Object res = NonBlockingHashMap.putIfMatch0(this, this._kvs, key, newVal, oldVal);
        assert (!(res instanceof Prime));
        return (TypeV)(res == TOMBSTONE ? null : res);
    }

    public final TypeV putIfMatch(Object key, Object newVal, Object oldVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        Object res = NonBlockingHashMap.putIfMatch0(this, this._kvs, key, newVal, oldVal);
        assert (!(res instanceof Prime));
        assert (res != null);
        return (TypeV)(res == TOMBSTONE ? null : res);
    }

    @Override
    public void putAll(Map<? extends TypeK, ? extends TypeV> m) {
        for (Map.Entry<TypeK, TypeV> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Object[] newkvs = new NonBlockingHashMap<TypeK, TypeV>((int)8)._kvs;
        while (!this.CAS_kvs(this._kvs, newkvs)) {
        }
    }

    @Override
    public boolean containsValue(Object val) {
        if (val == null) {
            throw new NullPointerException();
        }
        for (TypeV V : this.values()) {
            if (V != val && !V.equals(val)) continue;
            return true;
        }
        return false;
    }

    protected void rehash() {
    }

    @Override
    public Object clone() {
        try {
            NonBlockingHashMap t = (NonBlockingHashMap)super.clone();
            t.clear();
            for (TypeK K : this.keySet()) {
                TypeV V = this.get(K);
                t.put(K, V);
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public String toString() {
        Iterator<Map.Entry<TypeK, TypeV>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<TypeK, TypeV> e = i.next();
            TypeK key = e.getKey();
            TypeV value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private static boolean keyeq(Object K, Object key, int[] hashes, int hash, int fullhash) {
        return K == key || (hashes[hash] == 0 || hashes[hash] == fullhash) && K != TOMBSTONE && key.equals(K);
    }

    @Override
    public TypeV get(Object key) {
        Object V = NonBlockingHashMap.get_impl(this, this._kvs, key);
        assert (!(V instanceof Prime));
        assert (V != TOMBSTONE);
        return (TypeV)V;
    }

    private static final Object get_impl(NonBlockingHashMap topmap, Object[] kvs, Object key) {
        int fullhash = NonBlockingHashMap.hash(key);
        int len = NonBlockingHashMap.len(kvs);
        CHM chm = NonBlockingHashMap.chm(kvs);
        int[] hashes = NonBlockingHashMap.hashes(kvs);
        int idx = fullhash & len - 1;
        int reprobe_cnt = 0;
        while (true) {
            Object K = NonBlockingHashMap.key(kvs, idx);
            Object V = NonBlockingHashMap.val(kvs, idx);
            if (K == null) {
                return null;
            }
            Object[] newkvs = chm._newkvs;
            if (NonBlockingHashMap.keyeq(K, key, hashes, idx, fullhash)) {
                if (!(V instanceof Prime)) {
                    return V == TOMBSTONE ? null : V;
                }
                return NonBlockingHashMap.get_impl(topmap, chm.copy_slot_and_check(topmap, kvs, idx, key), key);
            }
            if (++reprobe_cnt >= NonBlockingHashMap.reprobe_limit(len) || K == TOMBSTONE) {
                return newkvs == null ? null : NonBlockingHashMap.get_impl(topmap, topmap.help_copy(newkvs), key);
            }
            idx = idx + 1 & len - 1;
        }
    }

    public TypeK getk(TypeK key) {
        return (TypeK)NonBlockingHashMap.getk_impl(this, this._kvs, key);
    }

    private static final Object getk_impl(NonBlockingHashMap topmap, Object[] kvs, Object key) {
        int fullhash = NonBlockingHashMap.hash(key);
        int len = NonBlockingHashMap.len(kvs);
        CHM chm = NonBlockingHashMap.chm(kvs);
        int[] hashes = NonBlockingHashMap.hashes(kvs);
        int idx = fullhash & len - 1;
        int reprobe_cnt = 0;
        Object K;
        while ((K = NonBlockingHashMap.key(kvs, idx)) != null) {
            Object[] newkvs = chm._newkvs;
            if (NonBlockingHashMap.keyeq(K, key, hashes, idx, fullhash)) {
                return K;
            }
            if (++reprobe_cnt >= NonBlockingHashMap.reprobe_limit(len) || K == TOMBSTONE) {
                return newkvs == null ? null : NonBlockingHashMap.getk_impl(topmap, topmap.help_copy(newkvs), key);
            }
            idx = idx + 1 & len - 1;
        }
        return null;
    }

    private static final Object putIfMatch0(NonBlockingHashMap topmap, Object[] kvs, Object key, Object putval, Object expVal) {
        assert (putval != null);
        assert (!(putval instanceof Prime));
        assert (!(expVal instanceof Prime));
        int fullhash = NonBlockingHashMap.hash(key);
        int len = NonBlockingHashMap.len(kvs);
        CHM chm = NonBlockingHashMap.chm(kvs);
        int[] hashes = NonBlockingHashMap.hashes(kvs);
        int idx = fullhash & len - 1;
        int reprobe_cnt = 0;
        Object K = null;
        Object V = null;
        Object[] newkvs = null;
        while (true) {
            V = NonBlockingHashMap.val(kvs, idx);
            K = NonBlockingHashMap.key(kvs, idx);
            if (K == null) {
                if (putval == TOMBSTONE) {
                    return TOMBSTONE;
                }
                if (expVal == MATCH_ANY) {
                    return TOMBSTONE;
                }
                if (NonBlockingHashMap.CAS_key(kvs, idx, null, key)) {
                    chm._slots.add(1L);
                    hashes[idx] = fullhash;
                    break;
                }
                int dummy = DUMMY_VOLATILE;
                continue;
            }
            newkvs = chm._newkvs;
            if (NonBlockingHashMap.keyeq(K, key, hashes, idx, fullhash)) break;
            if (++reprobe_cnt >= NonBlockingHashMap.reprobe_limit(len) || K == TOMBSTONE) {
                newkvs = chm.resize(topmap, kvs);
                if (expVal != null) {
                    topmap.help_copy(newkvs);
                }
                return NonBlockingHashMap.putIfMatch0(topmap, newkvs, key, putval, expVal);
            }
            idx = idx + 1 & len - 1;
        }
        while (true) {
            if (putval == V) {
                return V;
            }
            if (newkvs == null && (V == null && chm.tableFull(reprobe_cnt, len) || V instanceof Prime)) {
                newkvs = chm.resize(topmap, kvs);
            }
            if (newkvs != null) {
                return NonBlockingHashMap.putIfMatch0(topmap, chm.copy_slot_and_check(topmap, kvs, idx, expVal), key, putval, expVal);
            }
            assert (!(V instanceof Prime));
            if (!(expVal == NO_MATCH_OLD || V == expVal || expVal == MATCH_ANY && V != TOMBSTONE && V != null || V == null && expVal == TOMBSTONE || expVal != null && expVal.equals(V))) {
                return V == null ? TOMBSTONE : V;
            }
            if (NonBlockingHashMap.CAS_val(kvs, idx, V, putval)) break;
            V = NonBlockingHashMap.val(kvs, idx);
            if (V instanceof Prime) {
                return NonBlockingHashMap.putIfMatch0(topmap, chm.copy_slot_and_check(topmap, kvs, idx, expVal), key, putval, expVal);
            }
            int n = DUMMY_VOLATILE;
        }
        if (expVal != null) {
            if ((V == null || V == TOMBSTONE) && putval != TOMBSTONE) {
                chm._size.add(1L);
            }
            if (V != null && V != TOMBSTONE && putval == TOMBSTONE) {
                chm._size.add(-1L);
            }
        }
        return V == null && expVal != null ? TOMBSTONE : V;
    }

    private final Object[] help_copy(Object[] helper) {
        Object[] topkvs = this._kvs;
        CHM topchm = NonBlockingHashMap.chm(topkvs);
        if (topchm._newkvs == null) {
            return helper;
        }
        topchm.help_copy_impl(this, topkvs, false);
        return helper;
    }

    public Object[] raw_array() {
        return (NonBlockingHashMap)this.new SnapshotV()._sskvs;
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object v) {
                return NonBlockingHashMap.this.containsValue(v);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<TypeK> keys() {
        return new SnapshotK();
    }

    @Override
    public Set<TypeK> keySet() {
        return new AbstractSet<TypeK>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean contains(Object k) {
                return NonBlockingHashMap.this.containsKey(k);
            }

            @Override
            public boolean remove(Object k) {
                return NonBlockingHashMap.this.remove(k) != null;
            }

            @Override
            public Iterator<TypeK> iterator() {
                return new SnapshotK();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                Object[] kvs = NonBlockingHashMap.this.raw_array();
                int sz = this.size();
                T[] r = a.length >= sz ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), sz);
                int j = 0;
                for (int i = 0; i < NonBlockingHashMap.len(kvs); ++i) {
                    Object K = NonBlockingHashMap.key(kvs, i);
                    Object V = Prime.unbox(NonBlockingHashMap.val(kvs, i));
                    if (K == null || K == TOMBSTONE || V == null || V == TOMBSTONE) continue;
                    if (j >= r.length) {
                        int sz2 = (int)Math.min(0x7FFFFFF7L, (long)j << 1);
                        if (sz2 <= r.length) {
                            throw new OutOfMemoryError("Required array size too large");
                        }
                        r = Arrays.copyOf(r, sz2);
                    }
                    r[j++] = K;
                }
                if (j <= a.length) {
                    if (a != r) {
                        System.arraycopy(r, 0, a, 0, j);
                    }
                    if (j < a.length) {
                        r[j++] = null;
                    }
                    return a;
                }
                return Arrays.copyOf(r, j);
            }
        };
    }

    @Override
    public Set<Map.Entry<TypeK, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<TypeK, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return NonBlockingHashMap.this.remove(e.getKey(), e.getValue());
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object v = NonBlockingHashMap.this.get(e.getKey());
                return v != null && v.equals(e.getValue());
            }

            @Override
            public Iterator<Map.Entry<TypeK, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (TypeK K : this.keySet()) {
            TypeV V = this.get(K);
            s.writeObject(K);
            s.writeObject(V);
        }
        s.writeObject(null);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initialize(8);
        while (true) {
            Object K = s.readObject();
            Object V = s.readObject();
            if (K == null) break;
            this.put((TypeK)K, (TypeV)V);
        }
    }

    private static final class CHM<TypeK, TypeV> {
        private final ConcurrentAutoTable _size;
        private final ConcurrentAutoTable _slots;
        volatile Object[] _newkvs;
        private static final AtomicReferenceFieldUpdater<CHM, Object[]> _newkvsUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, Object[].class, "_newkvs");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newkvs(Object[] newkvs) {
            while (this._newkvs == null) {
                if (!_newkvsUpdater.compareAndSet(this, null, newkvs)) continue;
                return true;
            }
            return false;
        }

        CHM(ConcurrentAutoTable size) {
            this._size = size;
            this._slots = new ConcurrentAutoTable();
        }

        private final boolean tableFull(int reprobe_cnt, int len) {
            return reprobe_cnt >= 10 && (reprobe_cnt >= NonBlockingHashMap.reprobe_limit(len) || this._slots.estimate_get() >= (long)(len >> 1));
        }

        private final Object[] resize(NonBlockingHashMap topmap, Object[] kvs) {
            int sz;
            assert (NonBlockingHashMap.chm(kvs) == this);
            Object[] newkvs = this._newkvs;
            if (newkvs != null) {
                return newkvs;
            }
            int oldlen = NonBlockingHashMap.len(kvs);
            int newsz = sz = this.size();
            if (sz >= oldlen >> 2) {
                newsz = oldlen << 1;
                if (4L * (long)sz >= (oldlen >> 20 != 0 ? 3L : 2L) * (long)oldlen) {
                    newsz = oldlen << 2;
                }
            }
            long tm = System.currentTimeMillis();
            if (newsz <= oldlen && tm <= topmap._last_resize_milli + 10000L) {
                newsz = oldlen << 1;
            }
            if (newsz < oldlen) {
                newsz = oldlen;
            }
            int log2 = 3;
            while (1 << log2 < newsz) {
                ++log2;
            }
            long len = (1L << log2 << 1) + 2L;
            if ((long)((int)len) != len && (long)sz > ((len = (1L << (log2 = 30)) + 2L) >> 2) + (len >> 1)) {
                throw new RuntimeException("Table is full.");
            }
            long r = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, r, r + 1L)) {
                r = this._resizers;
            }
            long megs = (1L << log2 << 1) + 8L << 3 >> 20;
            if (r >= 2L && megs > 0L) {
                newkvs = this._newkvs;
                if (newkvs != null) {
                    return newkvs;
                }
                try {
                    Thread.sleep(megs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((newkvs = this._newkvs) != null) {
                return newkvs;
            }
            newkvs = new Object[(int)len];
            newkvs[0] = new CHM<TypeK, TypeV>(this._size);
            newkvs[1] = new int[1 << log2];
            if (this._newkvs != null) {
                return this._newkvs;
            }
            if (this.CAS_newkvs(newkvs)) {
                topmap.rehash();
            } else {
                newkvs = this._newkvs;
            }
            return newkvs;
        }

        private final void help_copy_impl(NonBlockingHashMap topmap, Object[] oldkvs, boolean copy_all) {
            assert (NonBlockingHashMap.chm(oldkvs) == this);
            Object[] newkvs = this._newkvs;
            assert (newkvs != null);
            int oldlen = NonBlockingHashMap.len(oldkvs);
            int MIN_COPY_WORK = Math.min(oldlen, 1024);
            int panic_start = -1;
            int copyidx = -9999;
            while (this._copyDone < (long)oldlen) {
                if (panic_start == -1) {
                    copyidx = (int)this._copyIdx;
                    while (!_copyIdxUpdater.compareAndSet(this, copyidx, copyidx + MIN_COPY_WORK)) {
                        copyidx = (int)this._copyIdx;
                    }
                    if (copyidx >= oldlen << 1) {
                        panic_start = copyidx;
                    }
                }
                int workdone = 0;
                for (int i = 0; i < MIN_COPY_WORK; ++i) {
                    if (!this.copy_slot(topmap, copyidx + i & oldlen - 1, oldkvs, newkvs)) continue;
                    ++workdone;
                }
                if (workdone > 0) {
                    this.copy_check_and_promote(topmap, oldkvs, workdone);
                }
                copyidx += MIN_COPY_WORK;
                if (copy_all || panic_start != -1) continue;
                return;
            }
            this.copy_check_and_promote(topmap, oldkvs, 0);
        }

        private final Object[] copy_slot_and_check(NonBlockingHashMap topmap, Object[] oldkvs, int idx, Object should_help) {
            assert (NonBlockingHashMap.chm(oldkvs) == this);
            Object[] newkvs = this._newkvs;
            assert (newkvs != null);
            if (this.copy_slot(topmap, idx, oldkvs, this._newkvs)) {
                this.copy_check_and_promote(topmap, oldkvs, 1);
            }
            return should_help == null ? newkvs : topmap.help_copy(newkvs);
        }

        private final void copy_check_and_promote(NonBlockingHashMap topmap, Object[] oldkvs, int workdone) {
            assert (NonBlockingHashMap.chm(oldkvs) == this);
            int oldlen = NonBlockingHashMap.len(oldkvs);
            long copyDone = this._copyDone;
            assert (copyDone + (long)workdone <= (long)oldlen);
            if (workdone > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, copyDone, copyDone + (long)workdone)) {
                    copyDone = this._copyDone;
                    assert (copyDone + (long)workdone <= (long)oldlen);
                }
            }
            if (copyDone + (long)workdone == (long)oldlen && topmap._kvs == oldkvs && topmap.CAS_kvs(oldkvs, this._newkvs)) {
                topmap._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(NonBlockingHashMap topmap, int idx, Object[] oldkvs, Object[] newkvs) {
            Object key;
            while ((key = NonBlockingHashMap.key(oldkvs, idx)) == null) {
                NonBlockingHashMap.CAS_key(oldkvs, idx, null, TOMBSTONE);
            }
            Object oldval = NonBlockingHashMap.val(oldkvs, idx);
            while (!(oldval instanceof Prime)) {
                Prime box;
                Prime prime = box = oldval == null || oldval == TOMBSTONE ? TOMBPRIME : new Prime(oldval);
                if (NonBlockingHashMap.CAS_val(oldkvs, idx, oldval, box)) {
                    if (box == TOMBPRIME) {
                        return true;
                    }
                    oldval = box;
                    break;
                }
                oldval = NonBlockingHashMap.val(oldkvs, idx);
            }
            if (oldval == TOMBPRIME) {
                return false;
            }
            Object old_unboxed = ((Prime)oldval)._V;
            assert (old_unboxed != TOMBSTONE);
            NonBlockingHashMap.putIfMatch0(topmap, newkvs, key, old_unboxed, null);
            while (oldval != TOMBPRIME && !NonBlockingHashMap.CAS_val(oldkvs, idx, oldval, TOMBPRIME)) {
                oldval = NonBlockingHashMap.val(oldkvs, idx);
            }
            return oldval != TOMBPRIME;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object V) {
            this._V = V;
        }

        static Object unbox(Object V) {
            return V instanceof Prime ? ((Prime)V)._V : V;
        }
    }

    private class SnapshotV
    implements Iterator<TypeV>,
    Enumeration<TypeV> {
        final Object[] _sskvs;
        private int _idx;
        private Object _nextK;
        private Object _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            Object[] topkvs;
            while (true) {
                topkvs = NonBlockingHashMap.this._kvs;
                CHM topchm = NonBlockingHashMap.chm(topkvs);
                if (topchm._newkvs == null) break;
                topchm.help_copy_impl(NonBlockingHashMap.this, topkvs, true);
            }
            this._sskvs = topkvs;
            this.next();
        }

        int length() {
            return NonBlockingHashMap.len(this._sskvs);
        }

        Object key(int idx) {
            return NonBlockingHashMap.key(this._sskvs, idx);
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != 0 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == null || this._nextK == TOMBSTONE || (this._nextV = NonBlockingHashMap.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        public void removeKey() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            NonBlockingHashMap.this.putIfMatch(this._prevK, TOMBSTONE, NO_MATCH_OLD);
            this._prevV = null;
        }

        @Override
        public void remove() {
            this.removeKey();
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotK
    implements Iterator<TypeK>,
    Enumeration<TypeK> {
        final SnapshotV _ss;

        public SnapshotK() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public TypeK next() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public TypeK nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotE
    implements Iterator<Map.Entry<TypeK, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public Map.Entry<TypeK, TypeV> next() {
            this._ss.next();
            return new NBHMEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMEntry
    extends AbstractEntry<TypeK, TypeV> {
        NBHMEntry(TypeK k, TypeV v) {
            super(k, v);
        }

        @Override
        public TypeV setValue(TypeV val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this._val = val;
            return NonBlockingHashMap.this.put(this._key, val);
        }
    }
}

